// Plik: Array.cpp
// Elementy składowe klasy Array i definicje funkcji zaprzyjaźnionych
#include <iostream>
#include <iomanip>
#include <stdexcept>

#include "Array.h" // Definicja klasy Array
using namespace std;

// Konstruktor domyślny klasy Array (wielkość domyślna obiektu wynosi 10)
Array::Array( int arraySize )
   : size( arraySize > 0 ? arraySize : 
        throw invalid_argument( "Tablica musi być większa niż 0." ) ),
     ptr( new int[ size ] )
{
   for ( size_t i = 0; i < size; ++i )
      ptr[ i ] = 0; // Zdefiniowanie elementu tablicy opartej na wskaźnikach
} // Koniec konstruktora domyślnego klasy Array

// Konstruktor kopiujący klasy Array musi
// otrzymywać odwołanie do obiektu typu Array
Array::Array( const Array &arrayToCopy ) 
   : size( arrayToCopy.size ),
     ptr( new int[ size ] )
{
   for ( size_t i = 0; i < size; ++i )
      ptr[ i ] = arrayToCopy.ptr[ i ]; // Kopiowanie do obiektu
} // Koniec konstruktora kopiującego klasy Array

// Destruktor klasy Array
Array::~Array()
{
   delete [] ptr; // Zwolnienie pamięci zarezerwowanej przez tablicę opartą na wskaźnikach
} // Koniec destruktora klasy Array

// Funkcja zwraca liczbę elementów w obiekcie typu Array
size_t Array::getSize() const
{
   return size; // Liczba elementów w obiekcie typu Array
} // Koniec funkcji getSize()

// Przeciążony operator przypisania
// Unika wartości zwrotnych typu const: ( a1 = a2 ) = a3
const Array &Array::operator=( const Array &right )
{
   if ( &right != this ) // Uniknięcie samoprzypisania
   {
      // W przypadku obiektów Array o różnej wielkości należy usunąć pierwotny
      // obiekt typu Array po lewej stronie operatora, a następnie zaalokować nowy
      if ( size != right.size )
      {
         delete [] ptr; // Zwolnienie pamięci
         size = right.size; // Zmiana wielkości obiektu
         ptr = new int[ size ]; // Zarezerwowanie pamięci dla kopii obiektu typu Array
      } // Koniec wewnętrznej konstrukcji if

      for ( size_t i = 0; i < size; ++i )
         ptr[ i ] = right.ptr[ i ]; // Kopiowanie tablicy do obiektu
   } // Koniec zewnętrznej konstrukci if

   return *this; // Pozwala na użycie polecenia x = y = z
} // Koniec funkcji operator=()

// Ustalenie, czy dwa obiekty typu Array są równe, i zwrot
// wartości true, w przeciwnym razie wartością zwrotną jest false
bool Array::operator==( const Array &right ) const
{
   if ( size != right.size )
      return false; // Tablice o różnej liczbie elementów

   for ( size_t i = 0; i < size; ++i )
      if ( ptr[ i ] != right.ptr[ i ] )
         return false; // Zawartość obiektów typu Array nie jest taka sama

   return true; // Obiekty typu Array są takie same
} // Koniec funkcji operator==()

// Przeciążony operator indeksu dla innych niż const obiektów typu Array
// Zwrócone odwołanie powoduje utworzenie modyfikowalnej l-wartości
int &Array::operator[]( int subscript )
{
   // Sprawdzenie pod kątem błędu, gdy indeks jest spoza dozwolonego zakresu
   if ( subscript < 0 || subscript >= size )
      throw out_of_range( "Indeks spoza dozwolonego zakresu" );

   return ptr[ subscript ]; // Zwrot odwołania
} // Koniec funkcji operator[]()

// Przeciążony operator indeksu dla będącego stałą obiektu typu Array
// Zwrócone odwołanie stałej tworzy r-wartość
int Array::operator[]( int subscript ) const
{
   // Sprawdzenie pod kątem błędu, gdy indeks jest spoza dozwolonego zakresu
   if ( subscript < 0 || subscript >= size )
      throw out_of_range( "Indeks spoza dozwolonego zakresu" );

   return ptr[ subscript ]; // Zwracana jest kopia tego elementu
} // Koniec funkcji operator[]()

// Przeciążony w klasie Array operator dostarczania danych wejściowych
// Pobierane są wartości dla całego obiektu typu Array
istream &operator>>( istream &input, Array &a )
{
   for ( size_t i = 0; i < a.size; ++i )
      input >> a.ptr[ i ];

   return input; // Pozwala na użycie polecenia cin >> x >> y;
} // Koniec funkcji operator>>()

// Przeciążony w klasie Array operator dostarczania danych wyjściowych
ostream &operator<<( ostream &output, const Array &a )
{
   // Przekazanie prywatnej tablicy opartej na wskaźnikach 
   for ( size_t i = 0; i < a.size; ++i )
   {
      output << setw( 12 ) << a.ptr[ i ];

      if ( ( i + 1 ) % 4 == 0 ) // Każdy wiersz danych wyjściowych zawiera cztery liczby
         output << endl;
   } // Koniec konstrukcji for

   if ( a.size % 4 != 0 ) // Koniec ostatniego wiersza danych wyjściowych
      output << endl;

   return output; // Pozwala na użycie polecenia cout << x << y;
} // Koniec funkcji operator<<()
