// Plik: fig18_01.cpp
// Program testowy wykorzystujący klasę string biblioteki standardowej
#include <iostream>
#include <string> 
using namespace std;

int main()
{
   string s1( "wszystkiego" );
   string s2( " najlepszego" ); 
   string s3;

   // Testowanie przeciążonych operatorów równości i relacji
   cout << "Wartość s1 wynosi \"" << s1<< "\"; Wartość s2 wynosi \"" << s2
      << "\"; Wartość s3 wynosi \"" << s3 << '\"' 
      << "\n\nWyniki porównania wartości s2 i s1:"
      << "\ns2 == s1 generuje wynik " << ( s2 == s1 ? "true" : "false" )
      << "\ns2 != s1 generuje wynik " << ( s2 != s1 ? "true" : "false" )
      << "\ns2 >  s1 generuje wynik " << ( s2 > s1 ? "true" : "false" ) 
      << "\ns2 <  s1 generuje wynik " << ( s2 < s1 ? "true" : "false" )
      << "\ns2 >= s1 generuje wynik " << ( s2 >= s1 ? "true" : "false" )
      << "\ns2 <= s1 generuje wynik " << ( s2 <= s1 ? "true" : "false" );
      
   // Testowanie funkcji składowej empty()
   cout << "\n\nTestowanie s3.empty():" << endl;

   if ( s3.empty() )
   {
      cout << "Wartość s3 jest pusta; przypisanie s1 do s3;" << endl;
      s3 = s1  ; // Przypisanie s1 do s3
      cout << "Wartość s3 wynosi \"" << s3 << "\"";
   } // Koniec konstrukcji if

   // Testowanie przeciążonego operatora konkatenacji ciągu tekstowego
   cout << "\n\ns1 += s2 generuje wynik s1 = ";	
   s1 += s2; // Testowanie przeciążonej konkatenacji
   cout << s1;

   // Testowanie przeciążonego operatora konkatenacji ciągu tekstowego z ciągiem tekstowym w stylu języka C
   cout << "\n\ns1 += \" dla Ciebie\" generuje wynik" << endl;
   s1 += " dla Ciebie";  
   cout << "s1 = " << s1 << "\n\n";

   // Testowanie funkcji składowej substr()
   cout << "Podciąg ciągu tekstowego s1 od położenia 0\n"
      << "dla 23 znaków, s1.substr(0, 23), to:\n"
      << s1.substr( 0, 23 ) << "\n\n";

   // Testowanie opcji "koniec ciągu tekstowego" funkcji substr()
   cout << "Podciąg ciągu tekstowego s1 od\n"
      << "położenia 24, s1.substr(24), to:\n"
      << s1.substr( 24 ) << endl; 

   // Testowanie konstruktora kopiującego
   string s4( s1 );
   cout << "\ns4 = " << s4 << "\n\n";

   // Testowanie przeciążonego operatora przypisania z samoprzypisaniem
   cout << "Przypisanie s4 do s4" << endl;
   s4 = s4;
   cout << "s4 = " << s4 << endl;

   // Użycie przeciążonego operatora indeksu do utworzenia l-wartości
   s1[ 0 ] = 'W';
   s1[ 12 ] = 'N';
   cout << "\ns1 po wykonaniu s1[0] = 'W' i s1[12] = 'N' wynosi: "
      << s1 << "\n\n";

   // Użycie funkcji składowej at() do sprawdzenia, czy indeks nie wykracza poza zakres  
   try                                                               
   {                                                                 
      cout << "Próba przypisania 'd' do s1.at( 30 ) generuje wynik:" << endl;
      s1.at( 30 ) = 'd'; // BŁĄD: indeks spoza dozwolonego zakresu            
   } // Koniec bloku try                                                      
   catch ( out_of_range &ex )                                        
   {                                                                 
      cout << "Nastąpiło zgłoszenie wyjątku: " << ex.what() << endl;        
   } // Koniec bloku catch                                                    
} // Koniec funkcji main()
