// Plik: Time.h
// Klasa Time zawierająca konstruktor z argumentami domyślnymi
// Funkcje składowe są zdefiniowane w pliku Time.cpp

// Uniemożliwienie wielokrotnego dołączenia nagłówka
#ifndef TIME_H
#define TIME_H

// Definicja klasy Time
class Time 
{
public:
   explicit Time( int = 0, int = 0, int = 0 ); // Konstruktor domyślny

   // Funkcje typu set
   void setTime( int, int, int ); // Ustawienie godziny, minuty i sekundy
   void setHour( int ); // Ustawienie godziny (po weryfikacji danych)
   void setMinute( int ); // Ustawienie minuty (po weryfikacji danych)
   void setSecond( int ); // Ustawienie sekundy (po weryfikacji danych)

   // Funkcje typu get
   unsigned int getHour() const; // Zwrot wartości reprezentującej godzinę
   unsigned int getMinute() const; // Zwrot wartości reprezentującej minutę
   unsigned int getSecond() const; // Zwrot wartości reprezentującej sekundę

   void printUniversal() const; // Wyświetlenie godziny w formacie uniwersalnym
   void printStandard() const; // Wyświetlenie godziny w formacie standardowym
private:
   unsigned int hour; // 0 – 23 (zegar 24-godzinny)
   unsigned int minute; // 0 – 59
   unsigned int second; // 0 – 59
}; // Koniec klasy Time

#endif
