// Plik: Time.cpp
// Definicje funkcji składowych klasy Time
#include <iostream>
#include <iomanip>
#include <stdexcept>
#include "Time.h" // Dołączenie definicji klasy Time z pliku nagłówkowego Time.h
using namespace std;

// Konstruktor klasy Time inicjalizuje wszystkie elementy danych składowych
Time::Time( int hour, int minute, int second )
{
   setTime( hour, minute, second ); // Weryfikacja wartości i ich przypisanie
} // Koniec konstruktora klasy Time

// Ustawienie nowych wartości klasy Time z użyciem czasu uniwersalnego
void Time::setTime( int h, int m, int s )
{
   setHour( h ); // Zdefiniowanie wartości prywatnego pola hour
   setMinute( m ); // Zdefiniowanie wartości prywatnego pola minute
   setSecond( s ); // Zdefiniowanie wartości prywatnego pola second
} // Koniec funkcji setTime()

// Zdefiniowanie wartości reprezentującej godzinę
void Time::setHour( int h )
{
   if ( h >= 0 && h < 24 )
      hour = h;
   else
      throw invalid_argument( "Wartość godziny musi mieścić się w przedziale 0-23." );
} // Koniec funkcji setHour()

// Zdefiniowanie wartości reprezentującej minutę
void Time::setMinute( int m )
{
   if ( m >= 0 && m < 60 )
      minute = m;
   else
      throw invalid_argument( "Wartość minuty musi mieścić się w przedziale 0-59." );
} // Koniec funkcji setMinute()

// Zdefiniowanie wartości reprezentującej sekundę
void Time::setSecond( int s )
{
   if ( s >= 0 && s < 60 )
      second = s;
   else
      throw invalid_argument( "Wartość sekundy musi mieścić się w przedziale 0-59." );
} // Koniec funkcji setSecond()

// Zwrot wartości reprezentującej godzinę
unsigned int Time::getHour() const
{
   return hour;
} // Koniec funkcji getHour()

// Zwrot wartości reprezentującej minutę
unsigned Time::getMinute() const
{
   return minute;
} // Koniec funkcji getMinute()

// Zwrot wartości reprezentującej sekundę
unsigned Time::getSecond() const
{
   return second;
} // Koniec funkcji getSecond()

// Wyświetlenie godziny w formacie czasu uniwersalnego (GG:MM:SS)
void Time::printUniversal() const
{
   cout << setfill( '0' ) << setw( 2 ) << getHour() << ":"
      << setw( 2 ) << getMinute() << ":" << setw( 2 ) << getSecond();
} // Koniec funkcji printUniversal()

// Wyświetlenie godziny w formacie czasu uniwersalnego (GG:MM:SS AM lub PM)
void Time::printStandard() const
{
   cout << ( ( getHour() == 0 || getHour() == 12 ) ? 12 : getHour() % 12 )
      << ":" << setfill( '0' ) << setw( 2 ) << getMinute()
      << ":" << setw( 2 ) << getSecond() << ( hour < 12 ? " AM" : " PM" );
} // Koniec funkcji printStandard()
