// Plik: fig16_07.cpp
// Utworzenie wielu obiektów klasy GradeBook i użycie
// konstruktora GradeBook do określenia nazwy kursu podczas 
// tworzenia poszczególnych obiektów
#include <iostream>
#include <string> // Program używa standardowej w C++ klasy string
using namespace std;

// Definicja klasy GradeBook
class GradeBook
{
public:
   // Konstruktor inicjalizuje courseName z ciągiem tekstowym dostarczonym w postaci argumentu 
   explicit GradeBook( string name )
      : courseName( name ) // Metoda inicjalizacyjna elementu składowego przeprowadza inicjalizację courseName
   {
      // Pusta definicja 
   } // Koniec konstruktora GradeBook 

   // Funkcja pozwalająca zdefiniować nazwę kursu
   void setCourseName( string name )
   {
      courseName = name; // Nazwa kursu jest przechowywana w obiekcie
   } // Koniec funkcji setCourseName()

   // Funkcja pobierająca nazwę kursu
   string getCourseName() const
   {
      return courseName; // Zwrot wartości courseName obiektu
   } // Koniec funkcji getCourseName()

   // Wyświetlenie komunikatu powitalnego użytkownikowi klasy GradeBook
   void displayMessage() const
   {
      // Wywołanie funkcji getCourseName() w celu pobrania wartości courseName
      cout << "Witaj w dzienniku elektronicznym kursu\n" << getCourseName()    
         << "!" << endl;
   } // Koniec funkcji displayMessage()
private:
   string courseName; // Nazwa kursu reprezentowanego przez dany obiekt GradeBook
}; // Koniec klasy GradeBook

// Wykonywanie programu rozpoczyna się od funkcji main()
int main()
{
   // Utworzenie dwóch obiektów typu GradeBook
   GradeBook gradeBook1( "CS101 Wprowadzenie do programowania w C++" );
   GradeBook gradeBook2( "CS10 Struktury danych C++" );   

   // Wyświetlenie wartości początkowej courseName dla każdego obiektu typu GradeBook
   cout << "gradeBook1 utworzony dla kursu: " << gradeBook1.getCourseName()
      << "\ngradeBook2 utworzony dla kursu: " << gradeBook2.getCourseName()
      << endl;
} // Koniec funkcji main()
