// Plik: fig12_19.c
// Utworzenie binarnego drzewa wyszukiwania
// i poruszanie się po nim
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Struktura odwołująca się do samej siebie  
struct treeNode {
   struct treeNode *leftPtr; // Wskaźnik do lewego poddrzewa
   int data; // Wartość węzła
   struct treeNode *rightPtr; // Wskaźnik do prawego poddrzewa
};

typedef struct treeNode TreeNode; // Synonim dla struktury treeNode
typedef TreeNode *TreeNodePtr; // Synonim dla TreeNode*

// Prototypy funkcji
void insertNode(TreeNodePtr *treePtr, int value);
void inOrder(TreeNodePtr treePtr);
void preOrder(TreeNodePtr treePtr);
void postOrder(TreeNodePtr treePtr);

// Funkcja main() rozpoczyna wykonywanie programu
int main(void)
{ 
   TreeNodePtr rootPtr = NULL; // Początkowo drzewo jest puste

   srand(time(NULL)); 
   puts("Oto liczby, które zostały umieszczone w drzewie:");

   // Umieszczenie w drzewie losowo wybranych wartości z przedziału od 0 do 14
   for (unsigned int i = 1; i <= 10; ++i) { 
      int item = rand() % 15;
      printf("%3d", item);
      insertNode(&rootPtr, item);
   } 

   // Poruszanie się po drzewie za pomocą funkcji preOrder()
   puts("\n\nNawigacja z użyciem notacji preorder:");
   preOrder(rootPtr);

   // Poruszanie się po drzewie za pomocą funkcji inOrder()
   puts("\n\nNawigacja z użyciem notacji inorder:");
   inOrder(rootPtr);

   // Poruszanie się po drzewie za pomocą funkcji postOrder()
   puts("\n\nNawigacja z użyciem notacji postorder:");
   postOrder(rootPtr);
} 

// Wstawienie węzła do drzewa
void insertNode(TreeNodePtr *treePtr, int value)
{ 
   // Jeżeli drzewo jest puste
   if (*treePtr == NULL) {   
      *treePtr = malloc(sizeof(TreeNode));

      // Jeżeli pamięć została zaalokowana, należy przypisać dane
      if (*treePtr != NULL) { 
         (*treePtr)->data = value;
         (*treePtr)->leftPtr = NULL;
         (*treePtr)->rightPtr = NULL;
      } 
      else {
         printf("Nie udało się wstawić %d z powodu braku wolnej pamięci.\n", value);
      } 
   } 
   else { // Drzewo nie jest puste
      // Dane przeznaczone do wstawienia są mniejsze niż dane w bieżącym węźle
      if (value < (*treePtr)->data) {
         insertNode(&((*treePtr)->leftPtr), value);  
      }

      // Dane przeznaczone do wstawienia są większe niż dane w bieżącym węźle
      else if (value > (*treePtr)->data) {
         insertNode(&((*treePtr)->rightPtr), value);
      }
      else { // Powtarzające się dane zostają zignorowane
         printf("%s", "dup");
      } 
   } 
} 

// Nawigacja z użyciem notacji inorder
void inOrder(TreeNodePtr treePtr)
{ 
   // Po drzewie można się poruszać, jeśli nie jest puste
   if (treePtr != NULL) {
      inOrder(treePtr->leftPtr);
      printf("%3d", treePtr->data);
      inOrder(treePtr->rightPtr);
   }
} 

// Nawigacja z użyciem notacji preorder
void preOrder(TreeNodePtr treePtr)
{ 
   // Po drzewie można się poruszać, jeśli nie jest puste
   if (treePtr != NULL) {
      printf("%3d", treePtr->data);   
      preOrder(treePtr->leftPtr);
      preOrder(treePtr->rightPtr);  
   }
} 

// Nawigacja z użyciem notacji postorder.
void postOrder(TreeNodePtr treePtr)
{ 
   // Po drzewie można się poruszać, jeśli nie jest puste
   if (treePtr != NULL) {
      postOrder(treePtr->leftPtr);
      postOrder(treePtr->rightPtr);
      printf("%3d", treePtr->data);
   }
}
