// Plik: fig12_03.c
// Wstawianie i usuwanie węzłów na liście
#include <stdio.h>
#include <stdlib.h>

// Struktura odwołująca się do samej siebie
struct listNode {  
   char data; // Każdy węzeł listNode zawiera znak
   struct listNode *nextPtr; // Wskaźnik do następnego węzła
};

typedef struct listNode ListNode; // Synonim dla struktury listNode
typedef ListNode *ListNodePtr; // Synonim dla ListNode*

// Prototypy funkcji
void insert(ListNodePtr *sPtr, char value);
char delete(ListNodePtr *sPtr, char value);
int isEmpty(ListNodePtr sPtr);
void printList(ListNodePtr currentPtr);
void instructions(void);

int main(void)
{ 
   ListNodePtr startPtr = NULL; // Początkowo nie ma żadnych węzłów
   char item; // Znak wprowadzony przez użytkownika

   instructions(); // Wyświetlenie menu
   printf("%s", "? ");
   unsigned int choice; // Opcja wybrana przez użytkownika
   scanf("%u", &choice);

   // Pętla będzie wykonywana dopóty, dopóki użytkownik nie wybierze opcji 3
   while (choice != 3) { 

      switch (choice) { 
         case 1:
            printf("%s", "Wpisz dowolny znak: ");
            scanf("\n%c", &item);
            insert(&startPtr, item); // Wstawienie elementu na liście
            printList(startPtr);
            break;
         case 2: // Usunięcie elementu
            // Jeżeli lista nie jest pusta
            if (!isEmpty(startPtr)) { 
               printf("%s", "Wpisz znak, który ma zostać usunięty: ");
               scanf("\n%c", &item);

               // Jeżeli znak został znaleziony, należy go usunąć
               if (delete(&startPtr, item)) { // Usunięcie elementu
                  printf("Usunięto znak %c.\n", item);
                  printList(startPtr);
               } 
               else {
                  printf("Nie znaleziono znaku %c.\n\n", item);
               } 
            } 
            else {
               puts("Lista jest pusta.\n");
            } 

            break;
         default:
            puts("Nieprawidłowa opcja.\n");
            instructions();
            break;
      }

      printf("%s", "? ");
      scanf("%u", &choice);
   } 

   puts("Program zakończył działanie.");
} 

// Wyświetlenie użytkownikowi informacji o sposobie działania programu
void instructions(void)
{ 
   puts("Wybierz jedną z dostępnych opcji:\n"
      "   1 - wstawienie elementu na listę\n"
      "   2 - usunięcie elementu z listy\n"
      "   3 - zakończenie programu");
} 

// Wstawienie nowej wartości na liście, w kolejności sortowania
void insert(ListNodePtr *sPtr, char value)
{ 
   ListNodePtr newPtr = malloc(sizeof(ListNode)); // Utworzenie węzła

   if (newPtr != NULL) { // Czy dostępna jest wolna pamięć?
      newPtr->data = value; // Umieszczenie wartości w węźle
      newPtr->nextPtr = NULL; // Węzeł nie łączy się z innym węzłem

      ListNodePtr previousPtr = NULL;
      ListNodePtr currentPtr = *sPtr;

      // Pętla pozwalająca odszukać prawidłowe położenie na liście   
      while (currentPtr != NULL && value > currentPtr->data) {
         previousPtr = currentPtr; // Przejdź do… 
         currentPtr = currentPtr->nextPtr; // …następnego węzła
      }

      // Wstawienie nowego węzła na początku listy
      if (previousPtr == NULL) { 
         newPtr->nextPtr = *sPtr;
         *sPtr = newPtr;
      } 
      else { // Wstawienie nowego węzła między położeniami wskazywanymi przez previousPtr i currentPtr
         previousPtr->nextPtr = newPtr;
         newPtr->nextPtr = currentPtr;
      } 
   } 
   else {
      printf("Nie udało się wstawić %c z powodu braku wolnej pamięci.\n", value);
   } 
} 

// Usunięcie elementu listy
char delete(ListNodePtr *sPtr, char value)
{ 
   // Usunięcie pierwszego węzła po znalezieniu dopasowania
   if (value == (*sPtr)->data) { 
      ListNodePtr tempPtr = *sPtr; // Zatrzymanie węzła przeznaczonego do usunięcia
      *sPtr = (*sPtr)->nextPtr; // Wyciągnięcie węzła z węzła
      free(tempPtr); // Zwolnienie pamięci zajmowanej przez węzeł
      return value;
   } 
   else { 
      ListNodePtr previousPtr = *sPtr;
      ListNodePtr currentPtr = (*sPtr)->nextPtr;

      // Pętla pozwalająca odszukać prawidłowe położenie na liście
      while (currentPtr != NULL && currentPtr->data != value) { 
         previousPtr = currentPtr; // Przejdź do… 
         currentPtr = currentPtr->nextPtr; // …następnego węzła
      } 

      // Usunięcie węzła w położeniu currentPtr
      if (currentPtr != NULL) { 
         ListNodePtr tempPtr = currentPtr;
         previousPtr->nextPtr = currentPtr->nextPtr;
         free(tempPtr);
         return value;
      } 
   } 

   return '\0';
} 

// Jeżeli lista jest pusta, wartością zwrotną jest 1, w przeciwnym razie funkcja zwraca 0
int isEmpty(ListNodePtr sPtr)
{ 
   return sPtr == NULL;
}

// Wyświetlenie listy
void printList(ListNodePtr currentPtr)
{ 
   // Jeżeli lista jest pusta
   if (isEmpty(currentPtr)) {
      puts("Lista jest pusta.\n");
   } 
   else { 
      puts("Oto zawartość listy:");

      // Pętla będzie wykonywana aż do końca listy
      while (currentPtr != NULL) { 
         printf("%c --> ", currentPtr->data);
         currentPtr = currentPtr->nextPtr;   
      } 

      puts("NULL\n");
   } 
}
