// Plik: fig11_10.c
// Sekwencyjne utworzenie pliku o dostępie swobodnym
#include <stdio.h>

// Definicja struktury clientData
struct clientData {
   unsigned int acctNum; // Numer konta
   char lastName[15]; // Nazwisko klienta
   char firstName[10]; // Imię klienta
   double balance; // Saldo konta klienta
};
 
int main(void)
{ 
   FILE *cfPtr; // Wskaźnik prowadzący do pliku accounts.dat

   // Funkcja fopen() otwiera plik. Jeżeli plik nie może zostać otworzony, funkcja kończy działanie
   if ((cfPtr = fopen("accounts.dat", "wb")) == NULL) {
      puts("Nie udało się otworzyć pliku.");
   } 
   else { 
      // Utworzenie struktury clientData z informacjami domyślnymi
      struct clientData blankClient = {0, "", "", 0.0};  
   
      // Zapisanie w pliku 100 pustych rekordów
      for (unsigned int i = 1; i <= 100; ++i) {
         fwrite(&blankClient, sizeof(struct clientData), 1, cfPtr); 
      }

      fclose (cfPtr); // Funkcja fclose() zamyka plik
   } 
} 
