// Plik: fig07_24.c
// Tasowanie i rozdawanie kart
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define SUITS 4
#define FACES 13
#define CARDS 52

// Prototyp funkcji
void shuffle(unsigned int wDeck[][FACES]); // Tasowanie powoduje modyfikację wDeck
void deal(unsigned int wDeck[][FACES], const char *wFace[], 
   const char *wSuit[]); // Rozdawanie nie powoduje modyfikacji tablic

int main(void)
{
   // Inicjalizacja tablicy deck
   unsigned int deck[SUITS][FACES] = {0};

   srand(time(NULL)); // Wartość zalążka dla generatora liczb losowych
   shuffle(deck); // Tasowanie talii kart

   // Inicjalizacja tablicy kolorów
   const char *suit[SUITS] =
      {"kier", "karo", "trefl", "pik"};
   
   // Inicjalizacja tablicy figur
   const char *face[FACES] =
      {"as", "dwójka", "trójka", "czwórka",
      "piątka", "szóstka", "siódemka", "ósemka",
      "dziewiątka", "dziesiątka", "walet", "królowa", "król"};

   deal(deck, face, suit); // Rozdanie kart
} 

// Tasowanie talii kart
void shuffle(unsigned int wDeck[][FACES])
{
   // Dla każdej karty należy losowo wybrać element tablicy talii
   for (size_t card = 1; card <= CARDS; ++card) {
      size_t row; // Numer wiersza
      size_t column; // Numer kolumny

      // Losowe wybieranie elementu trzeba kontynuować aż do znalezienia pustego
      do {
         row = rand() % SUITS;
         column = rand() % FACES;
      } while(wDeck[row][column] != 0);

      // Umieszczenie numeru w wybranym elemencie
      wDeck[row][column] = card;
   } 
} 

// Rozdanie kart z talii
void deal(unsigned int wDeck[][FACES], const char *wFace[],
   const char *wSuit[])
{
   // Rozdanie poszczególnych kart
   for (size_t card = 1; card <= CARDS; ++card) {
      // Iteracja przez wiersze wDeck
      for (size_t row = 0; row < SUITS; ++row) {
         // Iteracja przez kolumny wDeck dla bieżącego wiersza
         for (size_t column = 0; column < FACES; ++column) {
            // Jeżeli element zawiera bieżącą kartę, należy ją wyświetlić
            if (wDeck[row][column] == card) {
               printf("%12s %-6s%c", wFace[column], wSuit[row],
                   card % 2 == 0 ? '\n' : '\t'); // Format dwukolumnowy
            } 
         } 
      } 
   } 
}
