// Plik: fig06_22.c
// Operacje na tablicy dwuwymiarowej
#include <stdio.h>
#define STUDENTS 3
#define EXAMS 4

// Prototypy funkcji
int minimum(const int grades[][EXAMS], size_t pupils, size_t tests);
int maximum(const int grades[][EXAMS], size_t pupils, size_t tests);
double average(const int setOfGrades[], size_t tests);
void printArray(const int grades[][EXAMS], size_t pupils, size_t tests);

// Funkcja main() rozpoczyna wykonywanie programu
int main(void)
{
   // Inicjalizacja tablicy grades dla trzech studentów (wierszy)
   int studentGrades[STUDENTS][EXAMS] =  
      { { 77, 68, 86, 73 },
        { 96, 87, 89, 78 },
        { 70, 90, 86, 81 } };

   // Wyświetlenie zawartości tablicy studentGrades
   puts("Zawartość tablicy:");
   printArray(studentGrades, STUDENTS, EXAMS);

   // Ustalenie najniższej i najwyższej oceny
   printf("\n\nNajniższa ocena: %d\nNajwyższa ocena: %d\n",
      minimum(studentGrades, STUDENTS, EXAMS),
      maximum(studentGrades, STUDENTS, EXAMS));

   // Obliczenie średniej oceny każdego studenta
   for (size_t student = 0; student < STUDENTS; ++student) {
      printf("Średnia ocena studenta %u to %.2f\n", 
         student, average(studentGrades[student], EXAMS));
   } 
} 

// Wyszukanie oceny najniższej
int minimum(const int grades[][EXAMS], size_t pupils, size_t tests)
{
   int lowGrade = 100; // Inicjalizacja z największą możliwą oceną

   // Iteracja przez tablicę ocen
   for (size_t i = 0; i < pupils; ++i) {

      // Iteracja przez kolumny ocen
      for (size_t j = 0; j < tests; ++j) {

         if (grades[i][j] < lowGrade) {
            lowGrade = grades[i][j];
         } 
      } 
   } 

   return lowGrade; // Zwrot najniższej oceny
} 

// Wyszukanie oceny najwyższej
int maximum(const int grades[][EXAMS], size_t pupils, size_t tests)
{
   int highGrade = 0; // Inicjalizacja z najniższą możliwą oceną

   // Iteracja przez tablicę ocen
   for (size_t i = 0; i < pupils; ++i) {

      // Iteracja przez kolumny ocen
      for (size_t j = 0; j < tests; ++j) {

         if (grades[i][j] > highGrade) {
            highGrade = grades[i][j];
         } 
      } 
   } 

   return highGrade; // Zwrot najwyższej oceny
} 

// Ustalenie średniej oceny danego studenta
double average(const int setOfGrades[], size_t tests)      
{                                                         
   int total = 0; // Suma wszystkich ocen                
                                                          
   // Suma wszystkich ocen jednego studenta                 
   for (size_t i = 0; i < tests; ++i) {                  
      total += setOfGrades[i];                          
   }                                         
                                                          
   return (double) total / tests; // Średnia
} 

// Wyświetlenie tablicy
void printArray(const int grades[][EXAMS], size_t pupils, size_t tests)
{
   // Nagłówek kolumny danych wyjściowych
   printf("%s", "                 [0]  [1]  [2]  [3]");

   // Wyświetlenie ocen w formacie tabelarycznym
   for (size_t i = 0; i < pupils; ++i) {

      // Wyświetlenie etykiety dla wiesza
      printf("\nstudentGrades[%u] ", i);

      // Wyświetlenie ocen jednego studenta
      for (size_t j = 0; j < tests; ++j) {
         printf("%-5d", grades[i][j]);
      } 
   } 
}
