// Plik: BasePlusCommissionEmployee.h
// Klasa BasePlusCommissionEmployee będąca klasą pochodną klasy CommissionEmployee
#ifndef BASEPLUS_H
#define BASEPLUS_H

#include <string> // Standardowa klasa string w C++
#include "CommissionEmployee.h" // Definicja klasy CommissionEmployee

class BasePlusCommissionEmployee : public CommissionEmployee
{
public:
   BasePlusCommissionEmployee( const std::string &, const std::string &,
      const std::string &, double = 0.0, double = 0.0, double = 0.0 );
   virtual ~BasePlusCommissionEmployee() { } // Destruktor wirtualny

   void setBaseSalary( double ); // Zdefiniowanie wynagrodzenia zasadniczego
   double getBaseSalary() const; // Pobranie wynagrodzenia zasadniczego
   
   // Słowo kluczowe virtual oznacza, że funkcja powinna być nadpisana                
   virtual double earnings() const override; // Obliczenie wynagrodzenia
   virtual void print() const override; // Wyświetlenie zawartości obiektu
private:
   double baseSalary; // Tygodniowe wynagrodzenie zasadnicze
}; // Koniec klasy BasePlusCommissionEmployee

#endif // BASEPLUS_H
