// Plik: Employee.h
// Definicja klasy Employee przedstawia użycie kompozycji
// Funkcje składowe są zdefiniowane w pliku Employee.cpp
#ifndef EMPLOYEE_H
#define EMPLOYEE_H

#include <string>
#include "Date.h" // Dołączenie definicji klasy Date

class Employee
{
public:
   Employee( const std::string &, const std::string &, 
      const Date &, const Date & );
   void print() const;
   ~Employee(); // Destruktor ma pokazać kolejność usuwania obiektów
private:
   std::string firstName; // Kompozycja: obiekt elementu składowego
   std::string lastName; // Kompozycja: obiekt elementu składowego
   const Date birthDate; // Kompozycja: obiekt elementu składowego
   const Date hireDate; // Kompozycja: obiekt elementu składowego
}; // Koniec klasy Employee

#endif
