// Plik: Date.h
// Definicja klasy Date wraz z przeciążonymi operatorami
#ifndef DATE_H
#define DATE_H

#include <array>
#include <iostream>

class Date
{
   friend std::ostream &operator<<( std::ostream &, const Date & );
public:
   Date( int m = 1, int d = 1, int y = 1900 ); // Konstruktor domyślny
   void setDate( int, int, int ); // Zdefiniowanie miesiąca, dnia i roku
   Date &operator++(); // Operator inkrementacji typu prefiks 
   Date operator++( int ); // Operator inkrementacji typu postfiks
   Date &operator+=( unsigned int ); // Dodanie dni i modyfikacja obiektu
   static bool leapYear( int ); // Czy mamy do czynienia z rokiem przestępnym?
   bool endOfMonth( int ) const; // Czy data wskazuje koniec miesiąca?
private:
   unsigned int month;
   unsigned int day;
   unsigned int year;

   static const std::array< unsigned int, 13 > days; // Liczba dni w miesiącu
   void helpIncrement(); // Funkcja narzędziowa przeznaczona do inkrementacji daty
}; // Koniec klasy Date.

#endif
