// Plik: PhoneNumber.cpp
// Przeciążone dla klasy PhoneNumber operatory
// wstawiania danych do strumienia i pobierania danych ze strumienia
#include <iomanip>
#include "PhoneNumber.h"
using namespace std;

// Przeciążony operator wstawiania danych do strumienia 
// Nie może być funkcją składową, jeśli chcesz go wywoływać 
// za pomocą cout << somePhoneNumber;
ostream &operator<<( ostream &output, const PhoneNumber &number )
{
   output << "(" << number.areaCode << ") "
      << number.exchange << "-" << number.line;
   return output; // Pozwala na użycie polecenia cout << a << b << c;
} // Koniec funkcji operator<<()

// Przeciążony operator pobierania danych ze strumienia 
// Nie może być funkcją składową, jeśli chcesz go wywoływać
// za pomocą cin >> somePhoneNumber;  
istream &operator>>( istream &input, PhoneNumber &number )
{
   input.ignore(); // Pominięcie nawiasu (
   input >> setw( 3 ) >> number.areaCode; // Pobranie numeru kierunkowego
   input.ignore( 2 ); // Pominięcie nawiasu ) i spacji
   input >> setw( 3 ) >> number.exchange; // Pobranie numeru centrali
   input.ignore(); // Pominięcie łącznika (-)
   input >> setw( 4 ) >> number.line; // Pobranie numeru abonenta
   return input; // Pozwala na użycie polecenia cin >> a >> b >> c;
} // Koniec funkcji operator>>()  
