// Plik: Employee.cpp
// Definicje funkcji składowych klasy Employee
#include <iostream>
#include "Employee.h" // Definicja klasy Employee
using namespace std;

// Zdefiniowanie i zainicjalizowanie statycznych danych składowych w zasięgu globalnej przestrzeni nazw
unsigned int Employee::count = 0; // Nie można użyć słowa kluczowego static

// Zdefiniowanie statycznej funkcji składowej, która będzie zwracała liczbę utworzonych
// obiektów klasy Employee (zadeklarowana w pliku Employee.h jako statyczna)
unsigned int Employee::getCount()
{
   return count;
} // Koniec funkcji statycznej getCount()

// Konstruktor inicjalizuje niestatyczne dane składowe i inkrementuje
// wartość statycznego elementu danych składowych count
Employee::Employee( const string &first, const string &last )
   : firstName( first ), lastName( last )
{
   ++count; // Inkrementacja wartości statycznego licznika obiektów klasy Employee
   cout << "Konstruktor klasy Employee dla osoby " << firstName
      << ' ' << lastName << " został właśnie wywołany." << endl;
} // Koniec konstruktora klasy Employee

// Destruktor zwalnia dynamicznie zaalokowaną pamięć
Employee::~Employee()
{
   cout << "Destruktor ~Employee() został wywołany dla osoby " << firstName
      << ' ' << lastName << endl;
    --count; // Dekrementacja wartości statycznego licznika obiektów klasy Employee
} // Koniec destruktora ~Employee()

// Zwrot imienia osoby
string Employee::getFirstName() const
{
   return firstName; // Zwrot kopii imienia
} // Koniec funkcji getFirstName()

// Zwrot nazwiska osoby
string Employee::getLastName() const
{
   return lastName; // Zwrot kopii nazwiska
} // Koniec funkcji getLastName()
