// Plik: GradeBook.cpp
// Implementacje definicji funkcji składowych klasy GradeBook
// Funkcja setCourseName() przeprowadza weryfikację danych
#include <iostream>
#include "GradeBook.h" // Dołączenie definicji klasy GradeBook
using namespace std;

// Konstruktor inicjalizuje courseName z ciągiem tekstowym dostarczonym w postaci argumentu
GradeBook::GradeBook( string name )
{
   setCourseName( name ); // Weryfikacja i zapisanie danych składowych courseName
} // Koniec konstruktora GradeBook

// Funkcja definiująca nazwę kursu  
// Gwarantuje, że nazwa kursu ma maksymalnie 25 znaków
void GradeBook::setCourseName( string name )
{
   if ( name.size() <= 25 ) // Jeżeli nazwa kursu ma maksymalnie 25 znaków
      courseName = name; // Nazwa kursu jest przechowywana w obiekcie

   if ( name.size() > 25 ) // Jeżeli nazwa kursu ma więcej niż 25 znaków
   {
      // Wartością courseName będzie pierwsze 25 znaków parametru name
      courseName = name.substr( 0, 25 ); // Początek w położeniu 0, długość wynosi 25

      cerr << "Nazwa \"" << name << "\" zawiera więcej niż dozwolone 25 znaków.\n"
         << "Długość courseName została ograniczona do pierwszych 25 znaków.\n" << endl;    
   } // Koniec konstrukcji if
} // Koniec funkcji setCourseName()

// Funkcja pobierająca nazwę kursu
string GradeBook::getCourseName() const
{
   return courseName; // Zwrot wartości courseName obiektu
} // Koniec funkcji getCourseName()

// Wyświetlenie komunikatu powitalnego użytkownikowi klasy GradeBook
void GradeBook::displayMessage() const
{
   // Wywołanie funkcji getCourseName() w celu pobrania wartości courseName
   cout << "Witaj w dzienniku elektronicznym kursu\n" << getCourseName()  
      << "!" << endl;
} // Koniec funkcji displayMessage()
