// Plik: fig15_05.cpp
// Porównanie przekazywania przez wartość i przekazywania przez referencję za pomocą parametrów referencyjnych
#include <iostream>
using namespace std;

int squareByValue( int ); // Prototyp funkcji (przekazanie przez wartość)
void squareByReference( int & ); // Prototyp funkcji (przekazanie przez referencję)
   
int main()
{
   // Przykład działania funkcji squareByValue()
   int x = 2; 
   cout << "x = " << x << " przed wywołaniem funkcji squareByValue()\n";
   cout << "Wartość zwrócona przez funkcję squareByValue(): " 
      << squareByValue( x ) << endl;  
   cout << "x = " << x << " po wykonaniu funkcji squareByValue()\n" << endl;

   // Przykład działania funkcji squareByReference()
   int z = 4; 
   cout << "z = " << z << " przed wywołaniem funkcji squareByReference()" << endl;
   squareByReference( z );
   cout << "z = " << z << " po wykonaniu funkcji squareByReference()" << endl;
} 

// Funkcja squareByValue() mnoży liczbę przez nią samą, umieszcza
// wynik w zmiennej number, a następnie zwraca nową wartość tej zmiennej
int squareByValue( int number )
{
   return number *= number; // Argument komponentu wywołującego nie został zmodyfikowany
}

// Funkcja squareByReference() mnoży wartość numberRef przez nią samą, umieszcza
// wynik w zmiennej, do której prowadzi numberRef w komponencie wywołującym funkcję
void squareByReference( int &numberRef )  
{
   numberRef *= numberRef; // Argument komponentu wywołującego został zmodyfikowany
}
