// Plik: fig14_02.c
// Stosowanie zmiennej długości listy argumentów
#include <stdio.h>
#include <stdarg.h>

double average(int i, ...); // Prototyp funkcji

int main(void)
{ 
   double w = 37.5; 
   double x = 22.5; 
   double y = 1.7;  
   double z = 10.2; 

   printf("%s%.1f\n%s%.1f\n%s%.1f\n%s%.1f\n\n",
      "w = ", w, "x = ", x, "y = ", y, "z = ", z);
   printf("%s%.3f\n%s%.3f\n%s%.3f\n",
      "Średnia dla elementów w oraz x wynosi ", average(2, w, x),
      "Średnia dla elementów w, x oraz y wynosi ", average(3, w, x, y),
      "Średnia dla elementów w, x, y oraz z wynosi ", 
      average(4, w, x, y, z));
} 

// Obliczanie wartości średniej
double average(int i, ...)
{ 
   double total = 0; // Inicjalizacja zmiennej total
   va_list ap; // Zmienna przechowująca informacje wymagane przez va_start i va_end

   va_start(ap, i); // Inicjalizacja obiektu va_list

   // Przetworzenie zmiennej długości listy argumentów
   for (int j = 1; j <= i; ++j) {
      total += va_arg(ap, double);
   } 

   va_end(ap); // Usunięcie zmiennej długości listy argumentów
   return total / i; // Obliczanie wartości średniej
}
