// Plik: fig12_13.c
// Przykładowa implementacja kolejki
#include <stdio.h>
#include <stdlib.h>

// Struktura odwołująca się do samej siebie                     
struct queueNode {                                
   char data; // Zdefiniowanie zmiennej data jako typu char
   struct queueNode *nextPtr; // Wskaźnik queueNode
};                                                

typedef struct queueNode QueueNode;
typedef QueueNode *QueueNodePtr;

// Prototypy funkcji
void printQueue(QueueNodePtr currentPtr);
int isEmpty(QueueNodePtr headPtr);
char dequeue(QueueNodePtr *headPtr, QueueNodePtr *tailPtr);
void enqueue(QueueNodePtr *headPtr, QueueNodePtr *tailPtr, char value);
void instructions(void);

// Funkcja main() rozpoczyna wykonywanie programu
int main(void)
{ 
   QueueNodePtr headPtr = NULL; // Inicjalizacja wskaźnika headPtr
   QueueNodePtr tailPtr = NULL; // Inicjalizacja wskaźnika tailPtr
   char item; // Dane wejściowe wprowadzone przez użytkownika

   instructions(); // Wyświetlenie menu
   printf("%s", "? ");
   unsigned int choice; // Opcja wybrana przez użytkownika
   scanf("%u", &choice);

   // Pętla będzie wykonywana dopóty, dopóki użytkownik nie wybierze opcji 3
   while (choice != 3) { 

      switch(choice) { 
         // Umieszczenie wartości w kolejce
         case 1:
            printf("%s", "Wpisz dowolny znak: ");
            scanf("\n%c", &item);
            enqueue(&headPtr, &tailPtr, item);
            printQueue(headPtr);
            break;
         // Usunięcie wartości z kolejki
         case 2:
            // Jeżeli kolejka nie jest pusta
            if (!isEmpty(headPtr)) { 
               item = dequeue(&headPtr, &tailPtr);
               printf("Znak %c został usunięty z kolejki.\n", item);
            } 

            printQueue(headPtr);
            break;
         default:
            puts("Nieprawidłowa opcja.\n");
            instructions();
            break;
      } 

      printf("%s", "? ");
      scanf("%u", &choice);
   } 

   puts("Program zakończył działanie.");
} 

// Wyświetlenie użytkownikowi informacji o sposobie działania programu
void instructions(void)
{ 
   printf ("Wybierz jedną z dostępnych opcji:\n"
           "   1 - dodanie elementu do kolejki\n"
           "   2 - usunięcie elementu z kolejki\n"
           "   3 - zakończenie programu\n");
} 

// Wstawienie węzła na końcu kolejki
void enqueue(QueueNodePtr *headPtr, QueueNodePtr *tailPtr, char value)
{ 
   QueueNodePtr newPtr = malloc(sizeof(QueueNode));

   if (newPtr != NULL) { // Czy dostępna jest wolna pamięć?
      newPtr->data = value;
      newPtr->nextPtr = NULL;

      // Jeżeli kolejka jest pusta, nowy węzeł należy wstawić na jej początku
      if (isEmpty(*headPtr)) {
         *headPtr = newPtr;
      } 
      else {
         (*tailPtr)->nextPtr = newPtr;
      } 

      *tailPtr = newPtr;
   } 
   else {
      printf("Nie udało się wstawić %c z powodu braku wolnej pamięci.\n", value);
   } 
} 

// Usunięcie węzła z początku kolejki
char dequeue(QueueNodePtr *headPtr, QueueNodePtr *tailPtr)
{
   char value = (*headPtr)->data;
   QueueNodePtr tempPtr = *headPtr;
   *headPtr = (*headPtr)->nextPtr;

   // Jeżeli kolejka jest pusta
   if (*headPtr == NULL) {
      *tailPtr = NULL;
   } 

   free(tempPtr);
   return value;
} 

// Jeżeli kolejka jest pusta, wartością zwrotną jest 1, w przeciwnym przypadku funkcja zwraca 0
int isEmpty(QueueNodePtr headPtr)
{ 
   return headPtr == NULL;
} 

// Wyświetlenie zawartości kolejki
void printQueue(QueueNodePtr currentPtr)
{ 
   // Jeżeli kolejka jest pusta
   if (currentPtr == NULL) {
      puts("Kolejka jest pusta.\n");
   } 
   else { 
      puts("Oto zawartość kolejki:");

      // Pętla będzie wykonywana aż do końca kolejki
      while (currentPtr != NULL) { 
         printf("%c --> ", currentPtr->data);
         currentPtr = currentPtr->nextPtr;
      } 

      puts("NULL\n");
   } 
}
