// Plik: fig06_11.c
// Tablica statyczna będzie zainicjalizowana z wartością zero, o ile nie została wyraźnie zainicjalizowana inną wartością
#include <stdio.h>

void staticArrayInit(void); // Prototyp funkcji
void automaticArrayInit(void); // Prototyp funkcji

// Funkcja main() rozpoczyna wykonywanie programu
int main(void)
{
   puts("Pierwsze wywołanie poszczególnych funkcji:");
   staticArrayInit();
   automaticArrayInit();

   puts("\n\nDrugie wywołanie poszczególnych funkcji:");
   staticArrayInit();
   automaticArrayInit();
} 
 
// Funkcja przedstawiająca użycie statycznej tablicy lokalnej
void staticArrayInit(void)
{
   // Inicjalizacja elementów z wartością 0 przed wywołaniem funkcji
   static int array1[3];

   puts("\nWartości po rozpoczęciu wykonywania funkcji staticArrayInit:");

   // Wyświetlenie zawartości tablicy array1
   for (size_t i = 0; i <= 2; ++i) {
      printf("array1[%u] = %d  ", i, array1[i]);
   } 

   puts("\nWartości po zakończeniu wykonywania funkcji staticArrayInit:");

   // Modyfikowanie i wyświetlenie zawartości tablicy array1
   for (size_t i = 0; i <= 2; ++i) {
      printf("array1[%u] = %d  ", i, array1[i] += 5);
   } 
} 

// Funkcja przedstawiająca użycie automatycznej tablicy lokalnej
void automaticArrayInit(void)
{
   // Inicjalizowanie elementów w trakcie każdego wywołania funkcji
   int array2[3] = {1, 2, 3};

   puts("\n\nWartości po rozpoczęciu wykonywania funkcji automaticArrayInit:");

   // Wyświetlenie zawartości tablicy array2
   for (size_t i = 0; i <= 2; ++i) {
      printf("array2[%u] = %d  ", i, array2[i]);
   } 

   puts("\nWartości po zakończeniu wykonywania funkcji automaticArrayInit:");

   // Modyfikowanie i wyświetlenie zawartości tablicy array2
   for (size_t i = 0; i <= 2; ++i) {
      printf("array2[%u] = %d  ", i, array2[i] += 5);
   } 
}
