// Plik: fig05_16.c
// Zasięg identyfikatorów
#include <stdio.h>

void useLocal(void); // Prototyp funkcji
void useStaticLocal(void); // Prototyp funkcji
void useGlobal(void); // Prototyp funkcji

int x = 1; // Zmienna globalna

int main(void)
{
   int x = 5; // Zmienna lokalna funkcji main()

   printf("Wartość zmiennej lokalnej x w zasięgu zewnętrznym funkcji main() to %d\n", x);

   { // Początek nowego zasięgu
      int x = 7; // Zmienna lokalna dla nowego zasięgu
          
      printf("Wartość zmiennej lokalnej x w zasięgu wewnętrznym funkcji main() to %d\n", x);  
    } // Koniec nowego zasięgu

   printf("Wartość zmiennej lokalnej x w zasięgu zewnętrznym funkcji main() to %d\n", x);

   useLocal(); // useLocal ma lokalną zmienną automatyczną x
   useStaticLocal(); // useStaticLocal ma lokalną zmienną statyczną x
   useGlobal(); // useGlobal używa zmiennej globalnej x
   useLocal(); // useLocal ponownie inicjalizuje lokalną zmienną automatyczną x
   useStaticLocal(); // Lokalna zmienna statyczna x zachowuje swoją wcześniejszą wartość
   useGlobal(); // Zmienna globalna x również zachowuje wartość

   printf("\nWartość zmiennej lokalnej x funkcji main() to %d\n", x);
} 

// W trakcie każdego wywołania useLocal ponownie inicjalizuje zmienną lokalną x
void useLocal(void)
{
   int x = 25; // Inicjalizowana w trakcie każdego wywołania funkcji useLocal()

   printf("\nPo rozpoczęciu wykonywania funkcji useLocal() wartość jej zmiennej lokalnej x to %d\n", x);
   ++x;
   printf("Po zakończeniu wykonywania funkcji useLocal() wartość jej zmiennej lokalnej x to %d\n", x);
} 

// useStaticLocal() inicjalizuje statyczną zmienną lokalną x tylko w trakcie 
// pierwszego wywołania tej funkcji; wartość x zostaje zachowana między
// wywołaniami tej funkcji
void useStaticLocal(void)
{
   // Zainicjalizowana tylko raz
   static int x = 50;

   printf("\nPo rozpoczęciu wykonywania funkcji useStaticLocal() wartość jej zmiennej lokalnej x to %d\n", x);
   ++x;
   printf("Po zakończeniu wykonywania funkcji useStaticLocal() wartość jej zmiennej lokalnej x to %d\n", x);
} 

// W trakcie każdego wywołania funkcja useGlobal() modyfikuje zmienną globalną x
void useGlobal(void)
{
   printf("\nPo rozpoczęciu wykonywania funkcji useGlobal() wartość zmiennej globalnej x to %d\n", x);
   x *= 10;
   printf("Po zakończeniu wykonywania funkcji useGlobal() wartość zmiennej globalnej x to %d\n", x);
}
