// Plik: fig21_11.cpp
// Tworzenie i testowanie nieparametryzowanych manipulatorów
// strumienia zdefiniowanych przez użytkownika
#include <iostream>
using namespace std;

// Manipulator strumienia bell (używający sekwencji sterującej \a)
ostream& bell( ostream& output )
{
   return output << '\a'; // Wywołanie dźwięku systemowego
} // Koniec manipulatora strumienia bell

// Manipulator strumienia carriageReturn (używający sekwencji sterującej \r)
ostream& carriageReturn( ostream& output )
{
   return output << '\r'; // Wyświetlenie znaku powrotu karetki
} // Koniec manipulatora strumienia carriageReturn

// Manipulator strumienia tab (używający sekwencji sterującej \t)
ostream& tab( ostream& output )
{
   return output << '\t'; // Wyświetlenie tabulatora
} // Koniec manipulatora strumienia tab

// Manipulator strumienia endLine (używający sekwencji sterującej \n i manipulatora
// strumienia flush w celu symulowania działania endl)
ostream& endLine( ostream& output )
{
   return output << '\n' << flush; // Wyświetlenie znaku końca wiersza, podobnie jak w przypadku endl
} // Koniec manipulatora strumienia endLine

int main()
{
   // Użycie manipulatorów strumienia tab i endLine
   cout << "Testowanie manipulatora strumienia tab:" << endLine
      << 'a' << tab << 'b' << tab << 'c' << endLine;

   cout << "Testowanie manipulatorów strumienia carriageReturn i bell:"
      << endLine << "..........";

   cout << bell; // Użycie manipulatora strumienia bell

   // Użycie manipulatorów strumienia carriageReturn i endLine
   cout << carriageReturn << "-----" << endLine;
} // Koniec funkcji main()
