// Plik: fig20_17.cpp
// Przetwarzanie obiektów klas pochodnych klasy Employee
// pojedynczo i polimorficznie za pomocą wiązania dynamicznego
#include <iostream>
#include <iomanip>
#include <vector>
#include "Employee.h"
#include "SalariedEmployee.h" 
#include "CommissionEmployee.h"  
#include "BasePlusCommissionEmployee.h" 
using namespace std;

void virtualViaPointer( const Employee * const ); // Prototyp
void virtualViaReference( const Employee & ); // Prototyp

int main()
{
   // Formatowanie liczb zmiennoprzecinkowych w danych wyjściowych
   cout << fixed << setprecision( 2 );

   // Utworzenie obiektów klas pochodnych
   SalariedEmployee salariedEmployee(                     
      "Jan", "Sawicki", "111-11-1111", 800 );              
   CommissionEmployee commissionEmployee( 
      "Sara", "Janowska", "333-33-3333", 10000, .06 );
   BasePlusCommissionEmployee basePlusCommissionEmployee( 
      "Bartek", "Lewicki", "444-44-4444", 5000, .04, 300 );
   
   cout << "Pracownicy przetworzeni pojedynczo za pomocą wiązania statycznego:\n\n";

   // Wyświetlenie informacji o pracownikach i ich wynagrodzeniu za pomocą wiązania statycznego
   salariedEmployee.print();
   cout << "\nWynagrodzenie: " << salariedEmployee.earnings() << "\n\n";
   commissionEmployee.print();
   cout << "\nWynagrodzenie: " << commissionEmployee.earnings() << "\n\n";
   basePlusCommissionEmployee.print();
   cout << "\nWynagrodzenie: " << basePlusCommissionEmployee.earnings()
      << "\n\n";

   // Utworzenie kontenera przechowującego trzy wskaźniki typu klasy bazowej
   vector< Employee * > employees( 3 );

   // Inicjalizacja kontenera wskaźnikami typu Employee
   employees[ 0 ] = &salariedEmployee;
   employees[ 1 ] = &commissionEmployee;
   employees[ 2 ] = &basePlusCommissionEmployee;

   cout << "Pracownicy przetworzeni polimorficznie za pomocą wiązania dynamicznego:\n\n";

   // Wywołanie virtualViaPointer() w celu wyświetlenia informacji o poszczególnych
   // pracownikach i ich wynagrodzeniu za pomocą wiązania dynamicznego
   cout << "Wywołania funkcji wirtualnych za pomocą wskaźników typu klasy bazowej:\n\n";

   for ( const Employee *employeePtr : employees )
      virtualViaPointer( employeePtr );  

   // Wywołanie virtualViaReference() w celu wyświetlenia informacji o poszczególnych
   // pracownikach i ich wynagrodzeniu za pomocą wiązania dynamicznego
   cout << "Wywołania funkcji wirtualnych za pomocą odwołań typu klasy bazowej:\n\n";

   for ( const Employee *employeePtr : employees )
      virtualViaReference( *employeePtr ); // Zwróć uwagę na odwołanie się do elementu
} // Koniec funkcji main()

// Wywołanie funkcji wirtualnych print() i earnings() klasy Employee
// za pomocą wskaźnika typu klasy bazowej i wiązania dynamicznego
void virtualViaPointer( const Employee * const baseClassPtr )
{
   baseClassPtr->print();
   cout << "\nWynagrodzenie: " << baseClassPtr->earnings() << "\n\n";
} // Koniec funkcji virtualViaPointer()

// Wywołanie funkcji wirtualnych print() i earnings() klasy Employee
// za pomocą odwołania typu klasy bazowej i wiązania dynamicznego
void virtualViaReference( const Employee &baseClassRef )
{
   baseClassRef.print();
   cout << "\nWynagrodzenie: " << baseClassRef.earnings() << "\n\n";
} // Koniec funkcji virtualViaReference()
