// Plik: CommissionEmployee.h
// Klasa CommissionEmployee dziedzicząca po klasie Employee
#ifndef COMMISSION_H
#define COMMISSION_H

#include <string> // Standardowa klasa string w C++
#include "Employee.h" // Definicja klasy Employee

class CommissionEmployee : public Employee
{
public:
   CommissionEmployee( const std::string &, const std::string &,
      const std::string &, double = 0.0, double = 0.0 );
   virtual ~CommissionEmployee() { } // Destruktor wirtualny

   void setCommissionRate( double ); // Zdefiniowanie procentowej wysokości prowizji
   double getCommissionRate() const; // Pobranie procentowej wysokości prowizji

   void setGrossSales( double ); // Zdefiniowanie wielkości sprzedaży
   double getGrossSales() const; // Pobranie wielkości sprzedaży

   // Słowo kluczowe virtual oznacza, że funkcja powinna być nadpisana               
   virtual double earnings() const override; // Obliczenie wynagrodzenia
   virtual void print() const override; // Wyświetlenie zawartości obiektu           
private:
   double grossSales; // Tygodniowa wielkość sprzedaży       
   double commissionRate; // Prowizja wyrażona w procentach
}; // Koniec klasy CommissionEmployee

#endif // COMMISSION_H
