// Plik: SalariedEmployee.cpp
// Definicje funkcji składowych klasy SalariedEmployee
#include <iostream>
#include <stdexcept>
#include "SalariedEmployee.h" // Definicja klasy SalariedEmployee
using namespace std;

// Konstruktor
SalariedEmployee::SalariedEmployee( const string &first, 
   const string &last, const string &ssn, double salary )
   : Employee( first, last, ssn )
{ 
   setWeeklySalary( salary ); 
} // Koniec konstruktora klasy SalariedEmployee

// Zdefiniowanie pensji tygodniowej
void SalariedEmployee::setWeeklySalary( double salary )
{ 
   if ( salary >= 0.0 )
      weeklySalary = salary;
   else
      throw invalid_argument( "Wynagrodzenie tygodniowe musi być wartością >= 0.0" );
} // Koniec funkcji setWeeklySalary()

// Pobranie pensji tygodniowej
double SalariedEmployee::getWeeklySalary() const
{
   return weeklySalary;
} // Koniec funkcji getWeeklySalary()

// Obliczenie wynagrodzenia
// Nadpisanie czystej funkcji wirtualnej earnings() klasy Employee
double SalariedEmployee::earnings() const 
{ 
   return getWeeklySalary(); 
} // Koniec funkcji earnings()

// Wyświetlenie informacji przechowywanych w obiekcie SalariedEmployee
void SalariedEmployee::print() const
{
   cout << "Pracownik etatowy: ";           
   Employee::print(); // Ponowne użycie funkcji print() abstrakcyjnej klasy bazowej
   cout << "\nPensja tygodniowa: " << getWeeklySalary();
} // Koniec funkcji print()
