// Plik: BasePlusCommissionEmployee.cpp
// Definicje funkcji składowych klasy BasePlusCommissionEmployee
#include <iostream>
#include <stdexcept>
#include "BasePlusCommissionEmployee.h"
using namespace std;

// Konstruktor
BasePlusCommissionEmployee::BasePlusCommissionEmployee( 
   const string &first, const string &last, const string &ssn, 
   double sales, double rate, double salary ) 
   // Jawne wywołanie konstruktora klasy bazowej
   : CommissionEmployee( first, last, ssn, sales, rate )
{
   setBaseSalary( salary ); // Weryfikacja i przypisanie wysokości wynagrodzenia zasadniczego
} // Koniec konstruktora klasy BasePlusCommissionEmployee

// Zdefiniowanie wynagrodzenia zasadniczego
void BasePlusCommissionEmployee::setBaseSalary( double salary )
{
   if ( salary >= 0.0 )                                        
      baseSalary = salary;                                     
   else                                                        
      throw invalid_argument( "Wynagrodzenie musi być wartością >= 0.0" );       
} // Koniec funkcji setBaseSalary()

// Pobranie wynagrodzenia zasadniczego
double BasePlusCommissionEmployee::getBaseSalary() const
{
   return baseSalary;
} // Koniec funkcji getBaseSalary()

// Obliczenie wynagrodzenia
double BasePlusCommissionEmployee::earnings() const
{
   // Klasa pochodna nie ma dostępu do prywatnych danych składowych klasy bazowej
   return baseSalary + ( commissionRate * grossSales );   
} // Koniec funkcji earnings()

// Wyświetlenie zawartości obiektu BasePlusCommissionEmployee
void BasePlusCommissionEmployee::print() const
{
   // Klasa pochodna nie ma dostępu do prywatnych danych składowych klasy bazowej 
   cout << "Pracownik otrzymujący wynagrodzenie zasadnicze i prowizję " << firstName << ' '
      << lastName << "\nNumer ubezpieczenia społecznego: " << socialSecurityNumber
      << "\nWielkość sprzedaży: " << grossSales
      << "\nWysokość prowizji: " << commissionRate
      << "\nWynagrodzenie zasadnicze: " << baseSalary;
} // Koniec funkcji print()
