// Plik: BasePlusCommissionEmployee.h
// Definicja klasy BasePluCommissionEmployee reprezentującej pracownika, który
// otrzymuje wynagrodzenie zasadnicze plus prowizję od wielkości sprzedaży
#ifndef BASEPLUS_H
#define BASEPLUS_H

#include <string> // Standardowa klasa string w C++

class BasePlusCommissionEmployee
{
public:
   BasePlusCommissionEmployee( const std::string &, const std::string &, 
      const std::string &, double = 0.0, double = 0.0, double = 0.0 );
   
   void setFirstName( const std::string & ); // Zdefiniowanie imienia
   std::string getFirstName() const; // Pobranie imienia

   void setLastName( const std::string & ); // Zdefiniowanie nazwiska
   std::string getLastName() const; // Pobranie nazwiska

   void setSocialSecurityNumber( const std::string & ); // Zdefiniowanie numeru ubezpieczenia społecznego
   std::string getSocialSecurityNumber() const; // Pobranie numeru ubezpieczenia społecznego

   void setGrossSales( double ); // Zdefiniowanie wielkości sprzedaży
   double getGrossSales() const; // Pobranie wielkości sprzedaży

   void setCommissionRate( double ); // Zdefiniowanie procentowej wysokości prowizji 
   double getCommissionRate() const; // Pobranie procentowej wysokości prowizji 

   void setBaseSalary( double ); // Zdefiniowanie wynagrodzenia zasadniczego
   double getBaseSalary() const; // Pobranie wynagrodzenia zasadniczego

   double earnings() const; // Obliczenie wynagrodzenia
   void print() const; // Wyświetlenie zawartości obiektu BasePlusCommissionEmployee
private:
   std::string firstName;
   std::string lastName;
   std::string socialSecurityNumber;
   double grossSales; // Tygodniowa wielkość sprzedaży
   double commissionRate; // Prowizja wyrażona w procentach
   double baseSalary; // Wynagrodzenie zasadnicze
}; // Koniec klasy BasePlusCommissionEmployee

#endif
