// Plik: CommissionEmployee.cpp
// Definicje funkcji składowych klasy CommissionEmployee
#include <iostream>
#include <stdexcept>
#include "CommissionEmployee.h" // Definicja klasy CommissionEmployee
using namespace std;

// Konstruktor
CommissionEmployee::CommissionEmployee(
   const string &first, const string &last, const string &ssn,
   double sales, double rate )
{
   firstName = first; // Ta wartość powinna zostać zweryfikowana
   lastName = last; // Ta wartość powinna zostać zweryfikowana
   socialSecurityNumber = ssn; // Ta wartość powinna zostać zweryfikowana
   setGrossSales( sales ); // Weryfikacja i przypisanie wielkości sprzedaży
   setCommissionRate( rate ); // Weryfikacja i przypisanie wysokości prowizji
} // Koniec konstruktora klasy CommissionEmployee

// Zdefiniowanie imienia
void CommissionEmployee::setFirstName( const string &first )
{
   firstName = first; // Ta wartość powinna być zweryfikowana
} // Koniec funkcji setFirstName()

// Pobranie imienia
string CommissionEmployee::getFirstName() const
{
   return firstName;
} // Koniec funkcji getFirstName()

// Zdefiniowanie nazwiska
void CommissionEmployee::setLastName( const string &last )
{
   lastName = last; // Ta wartość powinna zostać zweryfikowana
} // Koniec funkcji setLastName()

// Pobranie nazwiska
string CommissionEmployee::getLastName() const
{
   return lastName;
} // Koniec funkcji getLastName()

// Zdefiniowanie numeru ubezpieczenia społecznego
void CommissionEmployee::setSocialSecurityNumber( const string &ssn )
{
   socialSecurityNumber = ssn; // Ta wartość powinna zostać zweryfikowana
} // Koniec funkcji setSocialSecurityNumber()

// Pobranie numeru ubezpieczenia społecznego
string CommissionEmployee::getSocialSecurityNumber() const
{
   return socialSecurityNumber;
} // Koniec funkcji getSocialSecurityNumber()

// Zdefiniowanie wielkości sprzedaży
void CommissionEmployee::setGrossSales( double sales )
{
   if ( sales >= 0.0 )
      grossSales = sales;
   else
      throw invalid_argument( "Wielkość sprzedaży musi być wartością >= 0.0" );
} // Koniec funkcji setGrossSales()

// Pobranie wielkości sprzedaży
double CommissionEmployee::getGrossSales() const
{
   return grossSales;
} // Koniec funkcji getGrossSales()

// Zdefiniowanie procentowej wysokości prowizji
void CommissionEmployee::setCommissionRate( double rate )
{
   if ( rate > 0.0 && rate < 1.0 )
      commissionRate = rate;
   else
      throw invalid_argument( "Wysokość prowizji musi być wartością > 0.0 i < 1.0" );
} // Koniec funkcji setCommissionRate()

// Pobranie procentowej wysokości prowizji
double CommissionEmployee::getCommissionRate() const
{
   return commissionRate;
} // Koniec funkcji getCommissionRate()

// Obliczenie wynagrodzenia
double CommissionEmployee::earnings() const
{
   return commissionRate * grossSales;
} // Koniec funkcji earnings()

// Wyświetlenie obiektu CommissionEmployee
void CommissionEmployee::print() const
{
   cout << "Pracownik wynagradzany prowizyjnie: " << firstName << ' ' << lastName
      << "\nNumer ubezpieczenia społecznego: " << socialSecurityNumber
      << "\nWielkość sprzedaży: " << grossSales
      << "\nWysokość prowizji: " << commissionRate;
} // Koniec funkcji print()
