// Plik: Complex.cpp
// Definicje funkcji składowych klasy Complex
#include <iostream>
#include "Complex.h" // Definicja klasy Complex
using namespace std;

// Konstruktor
Complex::Complex( double realPart, double imaginaryPart ) 
   : real( realPart ),
     imaginary( imaginaryPart ) 
{ 
   // Pusta definicja klasy
} // Koniec konstruktora klasy Complex

// Operator dodawania
Complex Complex::operator+( const Complex &operand2 ) const
{
   return Complex( real + operand2.real, 
      imaginary + operand2.imaginary );
} // Koniec funkcji operator+()

// Operator odejmowania
Complex Complex::operator-( const Complex &operand2 ) const
{
   return Complex( real - operand2.real, 
      imaginary - operand2.imaginary );
} // Koniec funkcji operator-()

// Wyświetlenie obiektu klasy Complex w postaci (a, b)
void Complex::print() const
{ 
   cout << '(' << real << ", " << imaginary << ')';
} // Koniec funkcji print()
