// Plik: fig17_23.cpp 
// Użycie wskaźnika this w celu odwoływania się do elementów składowych obiektu
#include <iostream>
using namespace std;

class Test 
{
public:
   explicit Test( int = 0 ); // Konstruktor domyślny
   void print() const;
private:
   int x;
}; // Koniec klasy Test

// Konstruktor
Test::Test( int value ) 
   : x( value ) // Inicjalizacja elementu x wartością value
{ 
   // Pusta definicja
} // Koniec konstruktora klasy Test

// Wyświetlenie wartości x za pomocą jawnego i niejawnego użycia
// wskaźnika this; ujęcie *this w nawias jest konieczne
void Test::print() const   
{
   // Niejawne użycie wskaźnika this w celu uzyskania dostępu do danych składowych x
   cout << "        x = " << x;       

   // Jawne użycie wskaźnika this i operatora strzałki
   // w celu uzyskania dostępu do danych składowych x
   cout << "\n  this->x = " << this->x;

   // Jawne użycie wskaźnika this i operatora kropki
   // w celu uzyskania dostępu do danych składowych x
   cout << "\n(*this).x = " << ( *this ).x << endl;  
} // Koniec funkcji print()

int main()
{
   Test testObject( 12 ); // Utworzenie i inicjalizacja obiektu testObject

   testObject.print();
} // Koniec funkcji main()
