// Plik: fig14_06.c
// Stosowanie obsługi sygnałów
#include <stdio.h>
#include <signal.h>
#include <stdlib.h>
#include <time.h>

void signalHandler(int signalValue); // Prototyp funkcji

int main(void)
{ 
   signal(SIGINT, signalHandler); // Rejestracja obsługi sygnału
   srand(time(NULL));
   
   // Wyświetlanie liczb z przedziału od 1 do 100
   for (int i = 1; i <= 100; ++i) { 
      int x = 1 + rand() % 50; // Wygenerowanie liczby losowej pozwalającej na zgłoszenie sygnału SIGINT
      
      // Zgłoszenie sygnału SIGINT, gdy wartością x jest 25
      if (x == 25) {
         raise(SIGINT);
      } 

      printf("%4d", i);
      
      // Wyświetlenie znaku \n, gdy wartość i jest wielokrotnością 10
      if (i % 10 == 0) {
         printf("%s", "\n");
      } 
   } 
} 

// Obsługa sygnału 
void signalHandler(int signalValue)
{ 
   printf("%s%d%s\n%s",
      "\nOtrzymano sygnał (", signalValue, ") kończący działanie programu.",
      "Czy chcesz kontynuować program (1 = tak, 2 = nie)? ");
   int response; // Odpowiedź udzielona przez użytkownika (1 lub 2)
   scanf("%d", &response);
   
   // Sprawdzenie pod kątem nieprawidłowej odpowiedzi
   while (response != 1 && response != 2) { 
      printf("%s", "(1 = tak, 2 = nie)? ");
      scanf("%d", &response);
   } 
   
   // Ustalenie, czy należy zakończyć działanie programu
   if (response == 1) {
       // Ponowna rejestracja obsługi sygnału SIGINT
      signal(SIGINT, signalHandler);
   } 
   else {
      exit(EXIT_SUCCESS);
   } 
}
