// Plik: fig11_15.c
// Ten program przetwarzający transakcje sekwencyjnie odczytuje plik o dostępie swobodnym, 
// uaktualnia znajdujące się w nim dane, tworzy nowe dane przeznaczone do umieszczenia w pliku 
// oraz usuwa te, które wcześniej były w nim przechowywane
#include <stdio.h>

// Definicja struktury clientData               
struct clientData {                              
   unsigned int acctNum; // Numer konta
   char lastName[15]; // Nazwisko klienta     
   char firstName[10]; // Imię klienta 
   double balance; // Saldo konta klienta            
}; 

// Prototypy funkcji
unsigned int enterChoice(void);
void textFile(FILE *readPtr);
void updateRecord(FILE *fPtr);
void newRecord(FILE *fPtr);
void deleteRecord(FILE *fPtr);

int main(void)
{ 
   FILE *cfPtr; // Wskaźnik prowadzący do pliku accounts.dat

   // Funkcja fopen() otwiera plik. Jeżeli plik nie może zostać otworzony, funkcja kończy działanie
   if ((cfPtr = fopen("accounts.dat", "rb+")) == NULL) {
      puts("Nie udało się otworzyć pliku.");
   } 
   else { 
      unsigned int choice; // Opcja wybrana przez użytkownika

      // Umożliwienie użytkownikowi wyboru akcji
      while ((choice = enterChoice()) != 5) { 
         switch (choice) { 
            // Utworzenie pliku tekstowego na podstawie pliku rekordów
            case 1:
               textFile(cfPtr);
               break;
            // Uaktualnienie rekordu
            case 2:
               updateRecord(cfPtr);
               break;
            // Utworzenie rekordu
            case 3:
               newRecord(cfPtr);
               break;
            // Usunięcie istniejącego rekordu
            case 4:
               deleteRecord(cfPtr);
               break;
            // Wyświetlenie komunikatu, jeśli użytkownik nie wybrał prawidłowej opcji
            default:
               puts("Wybierz prawidłową opcję.");
               break;
         } 
      } 

      fclose(cfPtr); // Funkcja fclose() zamyka plik
   } 
} 

// Utworzenie sformatowanego pliku tekstowego, którego zawartość można wydrukować 
void textFile(FILE *readPtr)
{ 
   FILE *writePtr; // Wskaźnik do pliku accounts.dat

   // Funkcja fopen() otwiera plik. Jeżeli plik nie może zostać otworzony, funkcja kończy działanie
   if ((writePtr = fopen("accounts.dat", "w")) == NULL) {
      puts("Nie udało się otworzyć pliku.");
   } 
   else { 
      rewind(readPtr); // Wyzerowanie wskaźnika, aby prowadził na początek pliku
      fprintf(writePtr, "%-7s%-16s%-11s%10s\n", 
         "Konto", "Nazwisko", "Imię", "Saldo");

      // Skopiowanie wszystkich rekordów z pliku o dostępie swobodnym do pliku tekstowego
      while (!feof(readPtr)) { 
         // Utworzenie struktury clientData z informacjami domyślnymi
         struct clientData client = { 0, "", "", 0.0 };
         int result = 
            fread(&client, sizeof(struct clientData), 1, readPtr);

         // Zapisanie pojedynczego rekordu w pliku tekstowym
         if (result != 0 && client.acctNum != 0) {
            fprintf(writePtr, "%-7d%-16s%-11s%10.2f\n",
               client.acctNum, client.lastName,
               client.firstName, client.balance);
         } 
      }

      fclose(writePtr); // Funkcja fclose() zamyka plik
   } 
} 

// Uaktualnienie wysokości salda w rekordzie
void updateRecord(FILE *fPtr)
{ 
   // Pobranie numeru konta, którego rekord ma zostać uaktualniony
   printf("%s", "Podaj numer konta, którego rekord ma zostać uaktualniony (1 - 100): ");
   unsigned int account; // Numer konta
   scanf("%d", &account);

   // Przeniesienie do odpowiedniego rekordu wskaźnika położenia w pliku
   fseek(fPtr, (account - 1) * sizeof(struct clientData),
      SEEK_SET);

   // Utworzenie struktury clientData bez żadnych informacji
   struct clientData client = {0, "", "", 0.0};

   // Odczytanie rekordu z pliku
   fread(&client, sizeof(struct clientData), 1, fPtr);

   // Wyświetlenie komunikatu błędu, jeśli podany rekord nie istnieje
   if (client.acctNum == 0) {
      printf("Konto o numerze #%d nie zawiera żadnych informacji.\n", account);
   } 
   else { // Uaktualnienie rekordu
      printf("%-7d%-16s%-11s%10.2f\n\n", 
         client.acctNum, client.lastName, 
         client.firstName, client.balance);
      
      // Pobranie od użytkownika kwoty transakcji 
      printf("%s", "Podaj wysokość uznania (+) lub obciążenia (-): ");
      double transaction; // Kwota transakcji
      scanf("%lf", &transaction);
      client.balance += transaction; // Uaktualnienie salda w rekordzie
      
      printf("%-7d%-16s%-11s%10.2f\n", 
         client.acctNum, client.lastName, 
         client.firstName, client.balance);
      
      // Przeniesienie do odpowiedniego rekordu wskaźnika położenia w pliku
      fseek(fPtr, (account - 1) * sizeof(struct clientData),
         SEEK_SET);

      // Zapisanie uaktualnionego rekordu w miejscu jego poprzedniej wersji znajdującej się w pliku
      fwrite(&client, sizeof(struct clientData), 1, fPtr);
   } 
} 

// Usunięcie istniejącego rekordu
void deleteRecord(FILE *fPtr)
{ 
   // Pobranie numeru konta przeznaczonego do usunięcia
   printf("%s", "Podaj numer konta, które ma zostać usunięte (1 - 100): ");
   unsigned int accountNum; // Numer konta
   scanf("%d", &accountNum);

   // Przeniesienie do odpowiedniego rekordu wskaźnika położenia w pliku
   fseek(fPtr, (accountNum - 1) * sizeof(struct clientData),
      SEEK_SET);

   struct clientData client; // Zmienna przechowująca rekord pobrany z pliku

   // Odczytanie rekordu z pliku
   fread(&client, sizeof(struct clientData), 1, fPtr);

   // Wyświetlenie komunikatu błędu, jeśli podany rekord nie istnieje
   if (client.acctNum == 0) {
      printf("Konto o numerze %d nie istnieje.\n", accountNum);
   } 
   else { // Usunięcie rekordu
      // Przeniesienie do odpowiedniego rekordu wskaźnika położenia w pliku 
      fseek(fPtr, (accountNum - 1) * sizeof(struct clientData),
         SEEK_SET);  

      struct clientData blankClient = {0, "", "", 0}; // Dane pustego rekordu
   
      // Zastąpienie istniejącego rekordu pustym
      fwrite(&blankClient,
         sizeof(struct clientData), 1, fPtr);
   } 
} 

// Utworzenie i wstawienie rekordu
void newRecord(FILE *fPtr)
{ 
   // Pobranie numeru konta, którego rekord ma zostać utworzony
   printf("%s", "Podaj nowy numer konta (1 - 100): ");
   unsigned int accountNum; // Numer konta
   scanf("%d", &accountNum);

   // Przeniesienie do odpowiedniego rekordu wskaźnika położenia w pliku
   fseek(fPtr, (accountNum - 1) * sizeof(struct clientData),
      SEEK_SET);  

   // Utworzenie struktury clientData z informacjami domyślnymi
   struct clientData client = { 0, "", "", 0.0 };

   // Odczytanie rekordu z pliku
   fread(&client, sizeof(struct clientData), 1, fPtr);

   // Wyświetlenie komunikatu błędu, jeśli rekord podanego konta już istnieje
   if (client.acctNum != 0) {
      printf("Konto o numerze #%d już zawiera informacje.\n",
         client.acctNum);
   } 
   else { // Utworzenie rekordu
      // Użytkownik podaje nazwisko, imię i saldo
      printf("%s", "Podaj następujące dane: nazwisko, imię i saldo\n? ");
      scanf("%14s%9s%lf", &client.lastName, &client.firstName, 
         &client.balance);

      client.acctNum = accountNum;
      
      // Przeniesienie do odpowiedniego rekordu wskaźnika położenia w pliku
      fseek(fPtr, (client.acctNum - 1) *
         sizeof(struct clientData), SEEK_SET);  
           
      // Wstawienie rekordu do pliku
      fwrite(&client,
         sizeof(struct clientData), 1, fPtr);
   } 
} 

// Umożliwienie użytkownikowi wybranie opcji z menu
unsigned int enterChoice(void)
{ 
   // Wyświetlenie dostępnych opcji menu
   printf("%s", "\nWybierz opcję\n"
      "1 - przechowywanie sformatowanej listy kont w pliku tekstowym\n"
      "    o nazwie \"accounts.dat\", który można wydrukować\n"
      "2 - uaktualnienie konta\n"
      "3 - dodanie nowego konta\n"
      "4 - usunięcie konta\n"
      "5 - koniec programu\n? ");

   unsigned int menuChoice; // Zmienna przechowująca opcję wybraną przez użytkownika
   scanf("%u", &menuChoice); // Pobranie opcji wybranej przez użytkownika
   return menuChoice;
}
