// Plik: fig11_11.c
// Losowy zapis danych w pliku o dostępie swobodnym
#include <stdio.h>

// Definicja struktury clientData               
struct clientData {                              
   unsigned int acctNum; // Numer konta
   char lastName[15]; // Nazwisko klienta    
   char firstName[10]; // Imię klienta 
   double balance; // Saldo konta klienta 
}; // Koniec definicji struktury clientData                   
 
int main(void) 
{ 
   FILE *cfPtr; // Wskaźnik prowadzący do pliku accounts.dat

   // Funkcja fopen() otwiera plik. Jeżeli plik nie może zostać otworzony, funkcja kończy działanie
   if ((cfPtr = fopen("accounts.dat", "rb+")) == NULL) {
      puts("Nie udało się otworzyć pliku.");
   } 
   else { 
      // Utworzenie struktury clientData z informacjami domyślnymi
      struct clientData client = {0, "", "", 0.0};

      // Użytkownik musi podać numer konta
      printf("%s", "Podaj numer konta"
         " (od 1 do 100, 0 kończy wprowadzanie danych): ");
      scanf("%d", &client.acctNum);

      // Użytkownik wprowadza informacje, które następnie zostają umieszczone w pliku
      while (client.acctNum != 0) { 
         // Użytkownik podaje nazwisko, imię i saldo
         printf("%s", "\nPodaj następujące dane: nazwisko, imię i saldo: ");
        
         // Zdefiniowanie wartości dla elementów składowych lastName, firstName i balance rekordu
         fscanf(stdin, "%14s%9s%lf", client.lastName, 
            client.firstName, &client.balance);

         // Odszukanie w pliku położenia rekordu wskazanego przez użytkownika
         fseek(cfPtr, (client.acctNum - 1) *  
            sizeof(struct clientData), SEEK_SET);

         // Zapisanie w pliku informacji podanych przez użytkownika
         fwrite(&client, sizeof(struct clientData), 1, cfPtr);

         // Umożliwienie użytkownikowi podanie innego numeru konta
         printf("%s", "\nPodaj numer konta: ");
         scanf("%d", &client.acctNum);
      } 

      fclose(cfPtr); // Funkcja fclose() zamyka plik
   } 
}