// Plik: fig10_07.c
// Wyświetlenie za pomocą bitów liczby całkowitej bez znaku
#include <stdio.h>

void displayBits(unsigned int value); // Prototyp funkcji

int main(void)
{ 
   unsigned int x; // Zmienna przechowująca dane wejściowe pochodzące od użytkownika	

   printf("%s", "Podaj nieujemną liczbę całkowitą: ");
   scanf("%u", &x);

   displayBits(x);
}

// Wyświetlenie bitów wartości w postaci liczby całkowitej bez znaku
void displayBits(unsigned int value)
{ 
   // Zdefiniowanie displayMask i przesunięcie bitów w lewo o 31 bitów
   unsigned int displayMask = 1 << 31; 

   printf("%10u = ", value);

   // Iteracja przez tablicę bitów
   for (unsigned int c = 1; c <= 32; ++c) { 
      putchar(value & displayMask ? '1' : '0');
      value <<= 1; // Przesunięcie wartości w lewą stronę o 1

      if (c % 8 == 0) { // Wyświetlenie spacji po 8 bitach
         putchar(' ');
      }
   }

   putchar('\n');
}
