// Plik: fig07_15.c
// Umieszczenie wartości w tablicy, sortowanie wartości w kolejności
// rosnącej, a następnie wyświetlenie otrzymanej tablicy
#include <stdio.h>
#define SIZE 10

void bubbleSort(int * const array, const size_t size); // Prototyp funkcji

int main(void)
{
   // Inicjalizacja tablicy a
   int a[SIZE] = { 2, 6, 4, 8, 10, 12, 89, 68, 45, 37 };
   
   puts("Elementy danych w pierwotnej kolejności:");

   // Iteracja przez tablicę a
   for (size_t i = 0; i < SIZE; ++i) {
      printf("%4d", a[i]);
   } 

   bubbleSort(a, SIZE); // Sortowanie tablicy

   puts("\nElementy danych w kolejności rosnącej:");
   
   // Iteracja przez tablicę a
   for (size_t i = 0; i < SIZE; ++i) {
      printf("%4d", a[i]);   
   } 

   puts("");
} 

// Sortowanie tablicy liczb całkowitych za pomocą algorytmu sortowania bąbelkowego
void bubbleSort(int * const array, const size_t size)
{
   void swap(int *element1Ptr, int *element2Ptr); // Prototyp funkcji
   
   // Pętla kontrolująca iteracje tablicy 
   for (unsigned int pass = 0; pass < size - 1; ++pass) {

      // Pętla kontrolująca porównania w trakcie każdej iteracji tablicy
      for (size_t j = 0; j < size - 1; ++j) {

         // Zamiana miejscami sąsiadujących elementów, o ile nie są ułożone w żądanej kolejności
         if (array[j] > array[j + 1]) {
            swap(&array[j], &array[j + 1]);
         } 
      } 
   } 
} 

  // Zamiana miejscami wartości w pamięci, w położeniach
  // wskazywanych przez element1Ptr i element2Ptr
  void swap(int *element1Ptr, int *element2Ptr)
  {
     int hold = *element1Ptr;
     *element1Ptr = *element2Ptr;
     *element2Ptr = hold;
}
