// Plik: fig06_23.c
// Stosowanie tablic o zmiennej wielkości zgodnych ze standardem C99
#include <stdio.h>

// Prototypy funkcji
void print1DArray(size_t size, int array[size]);
void print2DArray(size_t row, size_t col, int array[row][col]);

int main(void)
{
   printf("%s", "Podaj wielkość tablicy jednowymiarowej: ");
   int arraySize; // Wielkość tablicy jednowymiarowej
   scanf("%d", &arraySize);

   int array[arraySize]; // Deklarowana wielkość tablicy jednowymiarowej        

   printf("%s", "Podaj liczbę wierszy i kolumn w tablicy dwuwymiarowej: ");
   int row1, col1; // Liczba wierszy i kolumn w tablicy dwuwymiarowej
   scanf("%d %d", &row1, &col1);

   int array2D1[row1][col1]; // Deklarowana wielkość tablicy dwuwymiarowej

   printf("%s", 
      "Podaj liczbę wierszy i kolumn w kolejnej tablicy dwuwymiarowej: ");
   int row2, col2; // Liczba wierszy i kolumn w innej tablicy dwuwymiarowej
   scanf("%d %d", &row2, &col2);

   int array2D2[row2][col2]; // Deklarowana wielkość tablicy dwuwymiarowej

   // Przetestowanie operatora sizeof tablicy o zmiennej wielkości
   printf("\nLiczba zarezerwowanych przez sizeof(array) bajtów dla tablicy: %d\n",
      sizeof(array));                                     

   // Przypisanie wartości elementom jednowymiarowej tablicy o zmiennej wielkości
   for (size_t i = 0; i < arraySize; ++i) {
      array[i] = i * i;
   } 

   // Przypisanie wartości elementom pierwszej dwuwymiarowej tablicy o zmiennej wielkości
   for (size_t i = 0; i < row1; ++i) {
      for (size_t j = 0; j < col1; ++j) {
         array2D1[i][j] = i + j;
      } 
   } 

   // Przypisanie wartości elementom drugiej dwuwymiarowej tablicy o zmiennej wielkości
   for (size_t i = 0; i < row2; ++i) {
      for (size_t j = 0; j < col2; ++j) {
         array2D2[i][j] = i + j;
      } 
   } 

   puts("\nTablica jednowymiarowa:");
   print1DArray(arraySize, array); // Przekazanie funkcji jednowymiarowej tablicy o zmiennej wielkości

   puts("\nPierwsza tablica dwuwymiarowa:");
   print2DArray(row1, col1, array2D1); // Przekazanie funkcji pierwszej dwuwymiarowej tablicy o zmiennej wielkości

   puts("\nDruga tablica dwuwymiarowa:");
   print2DArray(row2, col2, array2D2); // Przekazanie funkcji drugiej dwuwymiarowej tablicy o zmiennej wielkości
} 

void print1DArray(size_t size, int array[size])
{
   // Wyświetlenie zawartości tablicy
   for (size_t i = 0; i < size; i++) {
      printf("array[%d] = %d\n", i, array[i]);
   } 
} 

void print2DArray(size_t row, size_t col, int array[row][col])
{
   // Wyświetlenie zawartości tablicy
   for (size_t i = 0; i < row; ++i) {
      for (size_t j = 0; j < col; ++j) {
         printf("%5d", array[i][j]);
      } 

      puts("");
   } 
}
