// Plik: fig06_18.c
// Wyszukiwanie liniowe elementu w tablicy
#include <stdio.h>
#define SIZE 100

// Prototyp funkcji
 size_t linearSearch(const int array[], int key, size_t size);

// Funkcja main() rozpoczyna wykonywanie programu
int main(void)
{   
   int a[SIZE]; // Utworzenie tablicy a

   // Utworzenie pewnych danych
   for (size_t x = 0; x < SIZE; ++x) { 
      a[x] = 2 * x;
   } 

   printf("Podaj klucz wyszukiwania w postaci liczby całkowitej: ");
   int searchKey; // Wartość do wyszukania w tablicy a
   scanf("%d", &searchKey);

   // Próba wyszukania searchKey w tablicy a
   size_t index = linearSearch(a, searchKey, SIZE);

   // Wyświetlenie wyników
   if (index != -1) {
      printf("Znaleziono wartość w położeniu o indeksie %d\n", index);
   } 
   else {
      puts("Nie znaleziono szukanej wartości");
   } 
} 

// Porównywanie klucza z każdym elementem tablicy aż do jego znalezienia 
// lub dotarcia do końca tablicy. Wartością zwrotną jest indeks elementu,
// jeśli klucz został znaleziony, lub -1 w przypadku nieznalezienia klucza     
size_t linearSearch(const int array[], int key, size_t size)
{
   // Iteracja przez tablicę 
   for (size_t n = 0; n < size; ++n) {
 
      if (array[n] == key) { 
         return n; // Zwrot indeksu znalezionego elementu 
      }
   }
 
   return -1; // Klucz nie został znaleziony
}
