// Plik: figD_02.c 
// Algorytm sortowania przez wstawianie 
#define SIZE 10
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Prototypy funkcji
void insertionSort(int array[], size_t length);
void printPass(int array[], size_t length, unsigned int pass, size_t index);

int main(void)
{
   int array[SIZE]; // Deklaracja tablicy zawierającej wartości typu int do posortowania
    
   srand(time(NULL)); // Wartość zalążka dla funkcji sortowania 
    
   for (size_t i = 0; i < SIZE; i++) {
      array[i] = rand() % 90 + 10; // Zdefiniowanie wartości dla każdego elementu 
   }
        
   puts("Tablica nieposortowana:");
    
   for (size_t i = 0; i < SIZE; i++) { // Wyświetlenie zawartości tablicy 
      printf("%d  ", array[i]);
   }
        
   puts("\n");
   insertionSort(array, SIZE);
   puts("Tablica posortowana:");
   
   for (size_t i = 0; i < SIZE; i++) { // Wyświetlenie zawartości tablicy 
      printf("%d  ", array[i]);
   }
}

// Funkcja sortująca tablicę 
void insertionSort(int array[], size_t length)
{
   // Iteracja przez wielkość_tablicy–1 elementów 
   for (size_t i = 1; i < length; i++) {
       size_t moveItem = i; // Inicjalizacja położenia, w którym zostanie wstawiony element 
       int insert = array[i]; // Zmienna przechowująca element przeznaczony do wstawienia
        
       // Wyszukiwanie miejsca, w którym ma zostać umieszczony bieżący element
       while (moveItem > 0 && array[moveItem - 1] > insert) {
           // Przesunięcie elementu w prawo o jedną pozycję 
           array[moveItem] = array[moveItem - 1];
           --moveItem;
       }
        
       array[moveItem] = insert; // Umieszczenie wstawionego elementu
       printPass(array, length, i, moveItem);
   } 
}

// Funkcja wyświetlająca wynik iteracji algorytmu 
void printPass(int array[], size_t length, unsigned int pass, size_t index)
{
   printf("Po iteracji %2d: ", pass);
    
   // Wyświetlenie elementów aż do wybranego 
   for (size_t i = 0; i < index; i++) {
       printf("%d  ", array[i]);
   }
        
   printf("%d* ", array[index]); // Wskazanie na zamianę elementów miejscami 
    
   // Dokończenie wyświetlania zawartości tablicy 
   for (size_t i = index + 1; i < length; i++) {
       printf("%d  ", array[i]);
   }
        
   printf("%s", "\n               "); // Na potrzeby wyrównania danych 
    
   // Pokazanie, jaka część tablicy została już posortowana
   for (size_t i = 0; i <= pass; i++) {
       printf("%s", "--  ");
   }
    
   puts(""); // Dodanie znaku nowego wiersza 
}
