// Plik: fig22_02.cpp
// Przykład zgłoszenia wyjątku
// podczas próby dzielenia przez zero
#include <iostream>
#include "DivideByZeroException.h" // Klasa DivideByZeroException
using namespace std;

// Przeprowadzenie operacji dzielenia i zgłoszenie obiektu typu DivideByZeroException,
// jeśli zostanie zgłoszony wyjątek wskazujący na próbę dzielenia przez zero
double quotient( int numerator, int denominator )
{
   // Próba dzielenia przez zero spowoduje zgłoszenie wyjątku DivideByZeroException
   if ( denominator == 0 )
     throw DivideByZeroException(); // Zakończenie działania funkcji

   // Zwrot wyniku operacji dzielenia
   return static_cast< double >( numerator ) / denominator;
} // Koniec funkcji quotient()

int main()
{
   int number1; // Licznik podany przez użytkownika
   int number2; // Mianownik podany przez użytkownika

   cout << "Podaj dwie liczby całkowite (EOF kończy działanie programu): ";

   // Umożliwienie użytkownikowi podania dwóch liczb całkowitych, które zostaną użyte podczas dzielenia
   while ( cin >> number1 >> number2 ) 
   {
      // Blok try zawiera kod, który może zgłosić wyjątek
      // Ten kod nie będzie wykonany po zgłoszeniu wyjątku
      try
      {
         double result = quotient( number1, number2 );
         cout << "Wartość współczynnika wynosi: " << result << endl;
      } // Koniec bloku try
      catch ( DivideByZeroException &divideByZeroException )
      {
         cout << "Został zgłoszony wyjątek: "   
            << divideByZeroException.what() << endl;
      } // Koniec bloku catch

      cout << "\nPodaj dwie liczby całkowite (EOF kończy działanie programu): ";
   } // Koniec pętli while

   cout << endl;
} // Koniec funkcji main()
