// Plik: fig22_05.cpp
// Pokazanie, jak standardowy operator new zgłasza
// wyjątek bad_alloc, gdy nie może zarezerwować pamięci
#include <iostream>
#include <new> // W tym nagłówku jest zdefiniowana klasa bad_alloc
using namespace std;

int main()
{
   double *ptr[ 50 ];
   
   // Każde wywołanie ptr[i] alokuje ogromną ilość pamięci
   try 
   {
      // Alokacja pamięci dla ptr[ i ]; w razie niepowodzenia operator new zgłasza wyjątek bad_alloc
      for ( size_t i = 0; i < 50; ++i ) 
      {
         ptr[ i ] = new double[ 50000000 ]; // To polecenie może zgłosić wyjątek
         cout << "ptr[" << i << "] prowadzi do 50 000 000 nowych wartości typu double\n";
      } // Koniec pętli for
   } // Koniec bloku try
   catch ( bad_alloc&memoryAllocationException )
   {
      cerr << "Został zgłoszony wyjątek: " 
         << memoryAllocationException.what() << endl;
   } // Koniec bloku catch
} // Koniec funkcji main()
