// Plik: BasePlusCommissionEmployee.cpp
// Definicje funkcji składowych klasy BasePlusCommissionEmployee
#include <iostream>
#include <stdexcept>
#include "BasePlusCommissionEmployee.h"
using namespace std;

// Konstruktor
BasePlusCommissionEmployee::BasePlusCommissionEmployee( 
   const string &first, const string &last, const string &ssn, 
   double sales, double rate, double salary ) 
   // Jawne wywołanie konstruktora klasy bazowej
   : CommissionEmployee( first, last, ssn, sales, rate )
{
   setBaseSalary( salary ); // Weryfikacja i przypisanie wysokości wynagrodzenia zasadniczego
} // Koniec konstruktora klasy BasePlusCommissionEmployee

// Zdefiniowanie wynagrodzenia zasadniczego
void BasePlusCommissionEmployee::setBaseSalary( double salary )
{
   if ( salary >= 0.0 )                                        
      baseSalary = salary;                                     
   else                                                        
      throw invalid_argument( "Wynagrodzenie musi być wartością >= 0.0" );       
} // Koniec funkcji setBaseSalary()

// Pobranie wynagrodzenia zasadniczego
double BasePlusCommissionEmployee::getBaseSalary() const
{
   return baseSalary;
} // Koniec funkcji getBaseSalary()

// Obliczenie wynagrodzenia
double BasePlusCommissionEmployee::earnings() const
{
   return getBaseSalary() + CommissionEmployee::earnings();
} // Koniec funkcji earnings()

// Wyświetlenie zawartości obiektu BasePlusCommissionEmployee
void BasePlusCommissionEmployee::print() const
{
   cout << "Pracownik otrzymujący wynagradzenie ";

   // Wywołanie funkcji print() klasy CommissionEmployee
   CommissionEmployee::print();
   
   cout << "\nWynagrodzenie zasadnicze: " << getBaseSalary();
} // Koniec funkcji print()
