// Plik: fig16_05.cpp
// Zdefiniowanie klasy GradeBook zawierającej dane składowe courseName
// i funkcje składowe umożliwiające zdefiniowanie i pobranie ich wartości 
// Utworzenie i stosowanie obiektu GradeBook za pomocą tych funkcji
#include <iostream>
#include <string> // Program używa standardowej w C++ klasy string
using namespace std;

// Definicja klasy GradeBook
class GradeBook
{
public:
   // Funkcja definiująca nazwę kursu
   void setCourseName( string name )
   {
      courseName = name; // Nazwa kursu jest przechowywana w obiekcie
   } // Koniec funkcji setCourseName()
   
   // Funkcja pobierająca nazwę kursu
   string getCourseName() const
   {
      return courseName; // Zwrot wartości courseName obiektu
   } // Koniec funkcji getCourseName()

   // Funkcja wyświetlająca komunikat powitania
   void displayMessage() const
   {
      // To polecenie wywołuje funkcję getCourseName() w celu pobrania 
      // nazwy kursu reprezentowanego przez dany obiekt GradeBook
      cout << "Witaj w dzienniku elektronicznym kursu\n" << getCourseName() << "!" 
         << endl;
   } // Koniec funkcji displayMessage()
private:
   string courseName; // Nazwa kursu reprezentowanego przez dany obiekt GradeBook
}; // Koniec klasy GradeBook

// Wykonywanie programu rozpoczyna się od funkcji main()
int main()
{
   string nameOfCourse; // Ciąg tekstowy znaków przechowujący nazwę kursu
   GradeBook myGradeBook; // Utworzenie obiektu typu GradeBook o nazwie myGradeBook
   
   // Wyświetlenie wartości początkowej courseName
   cout << "Początkowa nazwa kursu to: " << myGradeBook.getCourseName()  
      << endl;

   // Pobranie nazwy kursu i zdefiniowanie wartości odpowiedniej zmiennej
   cout << "\nPodaj nazwę kursu:" << endl;
   getline( cin, nameOfCourse ); // Pobranie nazwy kursu
   myGradeBook.setCourseName( nameOfCourse ); // Zdefiniowanie nazwy kursu

   cout << endl; // Wyświetlenie pustego wiersza
   myGradeBook.displayMessage(); // Wyświetlenie komunikatu powitalnego z nazwą kursu
} // Koniec funkcji main()
