// Plik: fig15_14.cpp
// Przykład użycia szablonu klasy vector biblioteki standardowej C++
#include <iostream>
#include <iomanip>
#include <vector>
using namespace std;

void outputVector( const vector< int > & ); // Wyświetlenie wektora
void inputVector( vector< int > & ); // Dane wejściowe wektora

int main()
{
   vector< int > integers1( 7 ); // 7-elementowy wektor < int >
   vector< int > integers2( 10 ); // 10-elementowy wektor < int >
 
   // Wyświetlenie wielkości i zawartości wektora integers1
   cout << "Wielkość wektora integers1 wynosi " <<  integers1.size()
      << "\nZawartość wektora po inicjalizacji:" << endl;
   outputVector( integers1 );

   // Wyświetlenie wielkości i zawartości wektora integers2
   cout << "\nWielkość wektora integers2 wynosi " <<  integers2.size()
      << "\nZawartość wektora po inicjalizacji:" << endl;
   outputVector( integers2 );

   // Pobranie danych wejściowych i wyświetlenie zawartości wektorów integers1 i integers2
   cout << "\nPodaj 17 liczb całkowitych:" << endl;
   inputVector( integers1 );
   inputVector( integers2 );

   cout << "\nPo podaniu danych wejściowych zawartość wektora przedstawia się następująco:\n"
      << "integers1:" << endl;
   outputVector( integers1 );
   cout << "integers2:" << endl;
   outputVector( integers2 );

   // Użycie operatora nierówności (!=) z obiektami typu vector
   cout << "\nObliczanie: integers1 != integers2" << endl;

   if ( integers1 != integers2 )
      cout << "Obiekty integers1 i integers2 nie są równe." << endl;

   // Utworzenie wektora integers3 z użyciem integers1 jako metody
   // inicjalizacyjnej, a następnie wyświetlenie wielkości i zawartości nowego wektora
   vector< int > integers3( integers1 ); // Konstruktor kopiujący

   cout << "\nWielkość wektora integers3 wynosi " << integers3.size()
      << "\nZawartość wektora po inicjalizacji:" << endl;
   outputVector( integers3 );
  
   // Użycie przeciążonego operatora przypisania (=).
   cout << "\nPrzypisanie integers2 do integers1:" << endl;
   integers1 = integers2; // Przypisanie integers2 do integers1

   cout << "integers1:" << endl;
   outputVector( integers1 );
   cout << "integers2:" << endl;
   outputVector( integers2 );

   // Użycie operatora równości (==) z obiektami typu vector
   cout << "\nObliczanie: integers1 == integers2" << endl;

   if ( integers1 == integers2 )
      cout << "Obiekty integers1 i integers2 są równe." << endl;

   // Użycie nawiasu kwadratowego do utworzenia r-wartości
   cout << "\nWartość integers1[5] wynosi " << integers1[ 5 ];

   // Użycie nawiasu kwadratowego do utworzenia l-wartości
   cout << "\n\nPrzypisanie 1000 do integers1[5]" << endl;
   integers1[ 5 ] = 1000;
   cout << "integers1:" << endl;
   outputVector( integers1 );

   // Próba użycia indeksu spoza dozwolonego zakresu
   try
   {
      cout << "\nPróba wyświetlenia wartości elementu integers1.at( 15 )" << endl;
      cout << integers1.at( 15 ) << endl; // BŁĄD: wartość spoza dozwolonego zakresu
   }
   catch ( out_of_range &ex )
   {
      cout << "Wystąpił wyjątek: " << ex.what() << endl;
   }
} 

// Wyświetlenie zawartości wektora
void outputVector( const vector< int > &array )
{
   size_t i; // Deklaracja zmiennej kontrolnej

   for ( i = 0; i < array.size(); ++i )
   {
      cout << setw( 12 ) << array[ i ];

      if ( ( i + 1 ) % 4 == 0 ) // Wiersz danych wyjściowych będzie zawierał 4 liczby
         cout << endl;
   } 

   if ( i % 4 != 0 )
      cout << endl;
} 

// Pobranie danych wejściowych wektora
void inputVector( vector< int > &array )
{
   for ( size_t i = 0; i <  array.size(); ++i )
      cin >> array[ i ];
}
