// Plik: fig11_14.c
// Odczytywanie danych z pliku o dostępie swobodnym
#include <stdio.h>

// Definicja struktury clientData               
 struct clientData {                              
   unsigned int acctNum; // Numer konta     
   char lastName[15]; // Nazwisko klienta     
   char firstName[10]; // Imię klienta   
   double balance; // Saldo konta klienta            
}; 

int main(void)
{ 
   FILE *cfPtr; // Wskaźnik prowadzący do pliku accounts.dat

   // Funkcja fopen() otwiera plik. Jeżeli plik nie może zostać otworzony, funkcja kończy działanie
   if ((cfPtr = fopen("accounts.dat", "rb")) == NULL) {
      puts("Nie udało się otworzyć pliku.");
   } 
   else { 
      printf("%-7s%-16s%-11s%10s\n", "Konto", "Nazwisko",
         "Imię", "Saldo");

      // Odczytywanie wszystkich rekordów z pliku (aż do napotkania znacznika końca pliku)
      while (!feof(cfPtr)) { 
         // Utworzenie struktury clientData z informacjami domyślnymi
         struct clientData client = {0, "", "", 0.0};

         int result = fread(&client, sizeof(struct clientData), 1, cfPtr);

         // Wyświetlenie rekordu
         if (result != 0 && client.acctNum != 0) {
            printf("%-7d%-16s%-11s%10.2f\n", 
               client.acctNum, client.lastName, 
               client.firstName, client.balance);
         } 
      } 

      fclose(cfPtr); // Funkcja fclose() zamyka plik
   } 
}
