// Fig. 6.16: fig06_16.c
// Analiza ankiety za pomocą tablic: 
// obliczanie średniej, mediany i dominanty danych
#include <stdio.h>
#define SIZE 99

// Prototypy funkcji
void mean(const unsigned int answer[]);
void median(unsigned int answer[]);
void mode(unsigned int freq[], unsigned const int answer[]) ;
void bubbleSort(unsigned int a[]);
void printArray(unsigned const int a[]);

// Funkcja main() rozpoczyna wykonywanie programu
int main(void)
{
   unsigned int frequency[10] = {0}; // Inicjalizacja tablicy frequency
   
   // Inicjalizacja tablicy response
   unsigned int response[SIZE] =             
      {6, 7, 8, 9, 8, 7, 8, 9, 8, 9,
       7, 8, 9, 5, 9, 8, 7, 8, 7, 8,
       6, 7, 8, 9, 3, 9, 8, 7, 8, 7,
       7, 8, 9, 8, 9, 8, 9, 7, 8, 9,
       6, 7, 8, 7, 8, 7, 9, 8, 9, 2,
       7, 8, 9, 8, 9, 8, 9, 7, 5, 3,
       5, 6, 7, 2, 5, 3, 9, 4, 6, 4,
       7, 8, 9, 6, 8, 7, 8, 9, 7, 8,
       7, 4, 4, 2, 5, 3, 8, 7, 5, 6,
       4, 5, 6, 1, 6, 5, 7, 8, 7};

   // Przetwarzanie tablicy response
   mean(response);
   median(response);
   mode(frequency, response);
} 

// Obliczanie średniej dla wszystkich wartości
void mean(const unsigned int answer[])
{
   printf("%s\n%s\n%s\n", "***********", "  Średnia", "***********");

   unsigned int total = 0; // Zmienna przechowująca sumę elementów

   // Całkowita liczba wartości tablicy response
   for (size_t j = 0; j < SIZE; ++j) {
      total += answer[j];
   } 

   printf("Średnia to przeciętna wartość elementów danych.\n"
           "Jest równa sumie wartości\n"
           "wszystkich elementów danych podzielonej przez\n"
           "liczbę elementów (%u). Średnia wartość w tym\n"
           "przypadku wynosi: %u / %u = %.4f\n\n",
           SIZE, total, SIZE, (double) total / SIZE);
}

// Sortowanie tablicy i ustalenie mediany wartości elementów
void median(unsigned int answer[])
{
   printf("\n%s\n%s\n%s\n%s", 
           "**********", " Mediana", "**********", 
           "Nieposortowana tablica odpowiedzi:");

   printArray(answer); // Wyświetlenie nieposortowanej tablicy

   bubbleSort(answer); // Sortowanie tablicy

   printf("%s", "\n\nPosortowana tablica odpowiedzi:");
   printArray(answer); // Wyświetlenie posortowanej tablicy

   // Wyświetlenie elementu mediany
   printf("\n\nMediana to element %u w\n"
          "posortowanej tablicy %u elementów.\n"
          "W omawianym przykładzie mediana to %u\n\n",
          SIZE / 2, SIZE, answer[SIZE / 2]);
} 

// Ustalenie najczęściej udzielanej odpowiedzi
void mode(unsigned int freq[], const unsigned int answer[])
{
   printf("\n%s\n%s\n%s\n","*************", "  Dominanta", "*************");

   // Inicjalizacja z wartością 0
   for (size_t rating = 1; rating <= 9; ++rating) {
      freq[rating] = 0;
   } 

   // Podsumowanie częstotliwości występowania wartości
   for (size_t j = 0; j < SIZE; ++j) {
      ++freq[answer[j]];
   } 

   // Nagłówki danych wyjściowych kolumn wyników
   printf("%s%20s%20s\n\n%53s\n%58s\n\n",
           "Odpowiedź", "Częstotliwość", "Histogram",
           "1    1    2    2", "5    0    5    0    5");

   // Wyświetlenie wyników
   unsigned int largest = 0; // Przedstawia największą częstotliwość
   unsigned int modeValue = 0; // Przedstawia najczęściej udzielaną odpowiedź

   for (size_t rating = 1; rating <= 9; ++rating) {
      printf("%9u%17u           ", rating, freq[rating]);

      // Monitorowanie wartości dominanty i największej częstotliwości
      if (freq[rating] > largest)  {                           
         largest = freq[rating];                        
         modeValue = rating;                        
      }                  

      // Wyświetlenie słupka histogramu przedstawiającego wartość częstotliwości
      for (unsigned int h = 1; h <= freq[rating]; ++h) {
         printf("%s", "*");
      } 

      puts(""); // Przejście na początek nowego wiersza danych wyjściowych
   } 

   // Wyświetlenie wartości dominanty
   printf("\nDominanta to najczęściej występująca wartość.\n"
          "W omawianym przykładzie to wartość %u, która wystąpiła"
          " %u razy.\n", modeValue, largest);
} 

// Funkcja sortująca tablicę za pomocą algorytmu sortowania bąbelkowego
void bubbleSort(unsigned int a[])
{
   // Pętla określająca liczbę iteracji
   for (unsigned int pass = 1; pass < SIZE; ++pass) {

      // Pętla określająca liczbę iteracji dla operacji porównania wartości
      for (size_t j = 0; j < SIZE - 1; ++j) {

         // Zamiana elementów miejscami, jeśli nie są w odpowiedniej kolejności
         if (a[j] > a[j + 1]) {
            unsigned int hold = a[j];
            a[j] = a[j + 1];
            a[j + 1] = hold;
         } 
      } 
   } 
} 

// Wyświetlenie zawartości tablicy (20 wartości w wierszu)
void printArray(const unsigned int a[])
{
   // Wyświetlenie zawartości tablicy
   for (size_t j = 0; j < SIZE; ++j) {

      if (j % 20 == 0) { // Przejście do nowego wiersza co 20 wartości
         puts("");
      } 

      printf("%2u", a[j]);
   } 
}
