// Plik: fig06_13.c
// Przekazywanie funkcji tablicy i jej poszczególnych elementów
#include <stdio.h>
#define SIZE 5

// Prototyp funkcji
void modifyArray(int b[], size_t size);
void modifyElement(int e);

// Funkcja main() rozpoczyna wykonywanie programu
int main(void)
{
   int a[SIZE] = {0, 1, 2, 3, 4}; // Inicjalizacja tablicy a

   puts("Efekt przekazania całej tablicy przez referencję:\n\n"
      "Oto wartości pierwotnej tablicy:");

   // Wyświetlenie pierwotnej tablicy
   for (size_t i = 0; i < SIZE; ++i) { 
      printf("%3d", a[i]);
   } 

   puts(""); // Wyświetlenie znaku nowego wiersza

   modifyArray(a, SIZE); // Przekazanie przez referencję tablicy a do funkcji modifyArray()
   puts("Oto wartości zmodyfikowanej tablicy:");

   // Wyświetlenie zmodyfikowanej tablicy
   for (size_t i = 0; i < SIZE; ++i) {
      printf("%3d", a[i]);
   } 

   // Wyświetlenie wartości elementu a[3]
   printf("\n\n\nEfekt przekazania elementu tablicy "
      "przez wartość:\n\nWartość elementu a[3] to %d\n", a[3]);
   
   modifyElement(a[3]); // Przekazanie elementu a[3] przez wartość

   // Wyświetlenie wartości elementu a[3]
   printf("Wartość elementu a[3] to %d\n", a[3]);
} 

// W funkcji modifyArray() "b" wskazuje na
// pierwotną tablicę "a" w pamięci    
void modifyArray(int b[], size_t size)   
{   
   // Mnożenie każdego elementu tablicy przez 2
   for (size_t j = 0; j < size; ++j) {
      b[j] *= 2; // Faktyczna modyfikacja pierwotnej tablicy 
   }
}
   
// W funkcji modifyElement() "e" to lokalna kopia
// elementu a[3] przekazanego z funkcji main()
void modifyElement(int e)
{
   // Mnożenie parametru przez 2
   printf("Wartość w funkcji modifyElement() to %d\n", e *= 2);
}
