// Plik: figD_01.c
// Algorytm sortowania przez wybieranie 
#define SIZE 10
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Prototypy funkcji
void selectionSort(int array[], size_t length);
void swap(int array[], size_t first, size_t second);
void printPass(int array[], size_t length, unsigned int pass, size_t index);

int main(void)
{
   int array[SIZE]; // Deklaracja tablicy zawierającej wartości typu int do posortowania
    
   srand(time(NULL)); // Wartość zalążka dla funkcji sortowania
    
   for (size_t i = 0; i < SIZE; i++) {
      array[i] = rand() % 90 + 10; // Zdefiniowanie wartości dla każdego elementu 
   }
        
   puts("Tablica nieposortowana:");
    
   for (size_t i = 0; i < SIZE; i++) { // Wyświetlenie zawartości tablicy 
      printf("%d  ", array[i]);
   }
        
   puts("\n");
   selectionSort(array, SIZE);
   puts("Tablica posortowana:");
    
   for (size_t i = 0; i < SIZE; i++) { // Wyświetlenie zawartości tablicy 
      printf("%d  ", array[i]);
   }
} 

// Funkcja implementująca sortowanie przez wybieranie
void selectionSort(int array[], size_t length)
{
   // Iteracja przez wielkość_tablicy–1 elementów 
   for (size_t i = 0; i < length - 1; i++) {
      size_t smallest = i; // Pierwszy indeks pozostałej części tablicy 
        
      // Pętla odszukująca indeks najmniejszego elementu
      for (size_t j = i + 1; j < length; j++) {
         if (array[j] < array[smallest]) {
            smallest = j;
         }
      }
                
      swap(array, i, smallest); // Zamiana miejscami najmniejszego elementu
      printPass(array, length, i + 1, smallest); // Wyświetlenie wyniku iteracji algorytmu
   } 
}

// Funkcja zamieniająca miejscami dwa elementy tablicy 
void swap(int array[], size_t first, size_t second)
{
   int temp = array[first];
   array[first] = array[second];
   array[second] = temp;
} 

// Funkcja wyświetlająca wynik iteracji algorytmu 
void printPass(int array[], size_t length, unsigned int pass, size_t index)
{
   printf("Po iteracji %2d: ", pass);
    
   // Wyświetlenie elementów aż do wybranego 
   for (size_t i = 0; i < index; i++) {
      printf("%d  ", array[i]);
   }
        
   printf("%d* ", array[index]); // Wskazanie na zamianę elementów miejscami 
    
   // Dokończenie wyświetlania zawartości tablicy 
   for (size_t i = index + 1; i < length; i++) {
      printf("%d  ", array[i]);
   }
        
   printf("%s", "\n               "); // Na potrzeby wyrównania danych 
    
   // Pokazanie, jaka część tablicy została już posortowana
   for (unsigned int i = 0; i < pass; i++) {
      printf("%s", "--  ");
   }
    
   puts(""); // Dodanie znaku nowego wiersza 
}
