// Przykładowy program gry w pokera z dodatku B książki Programowanie w języku C
// dla początkujących.
// Plik rBpoker.c

/* Program ten jest grą w pokera dobieranego. Użytkownik może grać,
ile chce i robić zakłady w wysokości od 1 do 5. Gracz otrzymuje 5 kart i
decyduje które z nich sobie zostawi, a które wymieni na inne. Następnie sprawdzane
są karty i obliczana jest wysokość wypłaty. Później zostają wyświetlone
nowy stan konta gracza i opcja kontynuacji gry. */

// pliki nagłówkowe

#include <stdio.h>
#include <time.h>
#include <ctype.h>
#include <stdlib.h>

// dwie stałe służące do sprawdzania czy gracz ma strita lub pokera

#define FALSE 0
#define TRUE 1

// prototypy funkcji

void printGreeting();
int getBet();
char getSuit(int suit);
char getRank(int rank);
void getFirstHand(int cardRank[], int cardSuit[]);
void getFinalHand(int cardRank[], int cardSuit[], int finalRank[],
                    int finalSuit[], int ranksinHand[],
int suitsinHand[]);
int analyzeHand(int ranksinHand[], int suitsinHand[]);

main()
{
    system("chcp 65001");

    int bet;
    int bank = 100;
    int i;
    int cardRank[5]; // może być jedną z 13 możliwych wartości (as, król itd.)
    int cardSuit[5]; // może być jedną z 4 możliwych wartości (żołądź, czerwień, dzwonek, wino)
    int finalRank[5];
    int finalSuit[5];
    int ranksinHand[13]; // służy do obliczania ostatecznego układu kart
    int suitsinHand[4]; // służy do oceny ostatecznego układu kart
    int winnings;
    time_t t;
    char suit, rank, stillPlay;

    // Funkcja ta jest wywoływana poza pętlę do...while, ponieważ
    // powitanie wystarczy wydrukować tylko raz, natomiast wszystko
    // pozostałe w funkcji main() może być wykonywane wiele razy,
    // w zależności od tego ile razy gracz postanowi zagrać.

    printGreeting();

    // pętla wykonywana w każdej partii
    do {
        bet = getBet();

        srand(time(&t));

        getFirstHand(cardRank, cardSuit);

        printf("Twoje pięć kart: \n");

        for (i = 0; i < 5; i++)
        {
            suit = getSuit(cardSuit[i]);
            rank = getRank(cardRank[i]);
            printf("Karta nr %d: %c%c\n", i+1, rank, suit);
        }

        // Te dwie tablice służą do sprawdzania wartości kart
        // w ręku gracza. Ale trzeba je zerować ze względu na to,
        // że gracz może mieć więcej niż jeden zestaw kart.

        for (i=0; i < 4; i++)
        {
            suitsinHand[i] = 0;
        }

        for (i=0; i < 13; i++)
        {
            ranksinHand[i] = 0;
        }

        getFinalHand(cardRank, cardSuit, finalRank, finalSuit,
                        ranksinHand, suitsinHand);

        printf("Ostateczny zestaw kart: \n");

        for (i = 0; i < 5; i++)
        {
            suit = getSuit(finalSuit[i]);
            rank = getRank(finalRank[i]);
            printf("Karta nr %d: %c%c\n", i+1, rank, suit);
        }

        winnings = analyzeHand(ranksinHand,suitsinHand);

        printf("Wygrałeś %d!\n", bet*winnings);

        bank = bank - bet + (bet*winnings);

        printf("\nKwota na koncie: %d.\n", bank);

        printf("\nChcesz zagrać jeszcze raz? ");
        scanf(" %c", &stillPlay);

    } while (toupper(stillPlay) == 'Y');

    return;
}

/******************************************************************/
// drukuje powitanie i wyświetla informacje o wartości wygrywających układów kart

void printGreeting()
{
    printf("***************************************************\n");
    printf("\n\n\tWitaj w kasynie dla programistów — \n\n");
    printf("\tdomu elektronicznego pokera dobieranego\n\n");
    printf("***************************************************\n");
    printf("Oto zasady gry:\n");
    printf("Na początek otrzymujesz 100 kredytów i stawiasz od ");
    printf("1 do 5 kredytów.\n");
    printf("Dostajesz pięć kart i wybierasz, które z nich ");
    printf("chcesz zatrzymać, ");
    printf("a które wolisz oddać.\n");
    printf("Dążysz do uzyskania jak najlepszego układu kart.\n");
    printf("\nOto tabela wygranych (przy założeniu, że postawiono ");
    printf("1 kredyt):");
    printf("\nPara\t\t\t\t1 kredyt");
    printf("\nDwie pary\t\t\t2 kredyty");
    printf("\nTrójka\t\t\t3 kredyty");
    printf("\nStrit\t\t\t4 kredyty");
    printf("\nKolor\t\t\t\t5 kredytów");
    printf("\nFull\t\t\t8 kredytów");
    printf("\nKareta\t\t\t10 kredytów");
    printf("\nPoker\t\t\t20 kredytów");
    printf("\n\nMiłej zabawy!!!\n\n");
}

// funkcja rozdająca pięć pierwszych kart

void getFirstHand(int cardRank[], int cardSuit[])
{
    int i,j;
    int cardDup;

    for (i=0; i < 5; i++)
    {
        cardDup = 0;
        do {
            // karta może mieć wartość od 1 do 13 (2-10, J, Q, K, A)
            cardRank[i] = (rand() % 13);

            // są cztery kolory kart
            // (żołędź, czerwo, dzwonek, wino)
            cardSuit[i] = (rand() % 4);

            // pętla zapewniająca, że żadna karta się nie powtarza

            for (j=0; j < i; j++)
            {
                if ((cardRank[i] == cardRank[j]) &&
                    (cardSuit[i] == cardSuit[j]))
                {
                    cardDup = 1;
                }
            }
        } while (cardDup == 1);
    }
}

// funkcja zmieniająca liczbę całkowitą reprezentującą kolor na literę

char getSuit(int suit)
{
    switch (suit)
    {
        case 0:
            return('ż');
        case 1:
            return('d');
        case 2:
            return('c');
        case 3:
            return('w');
    }
}

// funkcja zmieniająca liczbę okreœlającą wartość karty na znak
char getRank(int rank)
{
    switch (rank)
    {
        case 0:
            return('A');
        case 1:
            return('2');
        case 2:
            return('3');
        case 3:
            return('4');
        case 4:
            return('5');
        case 5:
            return('6');
        case 6:
            return('7');
        case 7:
            return('8');
        case 8:
            return('9');
        case 9:
            return('T');
        case 10:
            return('J');
        case 11:
            return('Q');
        case 12:
            return('K');
    }
}

// funkcja odbierająca zakład od użytkownika
int getBet()
{
    int bet;

    do // pętla powtarza się, aż gracz poda wartość z przedziału 0-5
    {
        printf("Ile chcesz postawić? (wpisz lczbę z przedziału ");
        printf("od 1 do 5 lub 0, aby zakończyć grę): ");
        scanf(" %d", &bet);

        if (bet >= 1 && bet <= 5)
        {
            return(bet);
        }
        else if (bet == 0)
        {
            exit(1);
        }
        else
        {
            printf("\n\nWpisz liczbę z przedziału od 1 do 5 lub ");
            printf("0, aby zakończyć grę.\n");
        }
    } while ((bet < 0) || (bet > 5));
}

// ostatnia funkcja, która analizuje ostateczny zestaw kart i określa jego wartość

int analyzeHand(int ranksinHand[], int suitsinHand[])
{
    int num_consec = 0;
    int i, rank, suit;
    int straight = FALSE;
    int flush = FALSE;
    int four = FALSE;
    int three = FALSE;
    int pairs = 0;

    for (suit = 0; suit < 4; suit++)
        if (suitsinHand[suit] == 5)
            flush = TRUE;
        rank = 0;
        while (ranksinHand[rank] == 0)
            rank++;
        for (; rank < 13 && ranksinHand[rank]; rank++)
            num_consec++;
        if (num_consec == 5) {
            straight = TRUE;
        }
        for (rank = 0; rank < 13; rank++) {
            if (ranksinHand[rank] == 4)
                four = TRUE;
            if (ranksinHand[rank] == 3)
                three = TRUE;
            if (ranksinHand[rank] == 2)
                pairs++;
        }

        if (straight && flush) {
            printf("Poker\n\n");
            return (20);
        }
        else if (four) {
            printf("Kareta\n\n");
            return (10);
        }
        else if (three && pairs == 1) {
            printf("Full\n\n");
            return (8);
        }
        else if (flush) {
            printf("Kolor\n\n");
            return (5);
        }
        else if (straight) {
            printf("Strit\n\n");
            return (4);
        }
        else if (three) {
            printf("Trójka\n\n");
            return (3);
        }
        else if (pairs == 2) {
            printf("Dwie pary\n\n");
            return (2);
        }
        else if (pairs == 1) {
            printf("Para\n\n");
            return (1);
        }
        else {
            printf("Wysoka karta\n\n");
            return (0);
        }
}

// Funkcja przeglądająca wszystkie pięć kart w pierwszym układzie
// i pytająca użytkownika, czy chce zachować każdą z nich. Jeśli padnie odpowiedź
// negatywna, wydaje graczowi inną kartę.

void getFinalHand(int cardRank[], int cardSuit[], int finalRank[],
                    int finalSuit[], int ranksinHand[],
                    int suitsinHand[])
{

    int i, j, cardDup;
    char suit, rank, ans;

    for (i=0; i < 5; i++)
    {
        suit = getSuit(cardSuit[i]);
        rank = getRank(cardRank[i]);

        printf("Czy chcesz zatrzymać kartę nr %d: %c%c?", i+1, rank, suit);
        printf("\nWpisz T lub N: ");
        scanf(" %c", &ans);

        if (toupper(ans) == 'T')
        {
            finalRank[i] = cardRank[i];
            finalSuit[i] = cardSuit[i];
            ranksinHand[finalRank[i]]++;
            suitsinHand[finalSuit[i]]++;
            continue;
        }
        else if (toupper(ans) == 'N')
        {
            cardDup = 0;
            do {
                cardDup = 0;

                finalRank[i] = (rand() % 13);
                finalSuit[i] = (rand() % 4);

                // porównanie nowej karty z pięcioma oryginalnymi
                // w celu uniknięcia duplikatów

                for (j=0; j < 5; j++)
                {
                    if ((finalRank[i] == cardRank[j]) &&
                        (finalSuit[i] == cardSuit[j]))
                    {
                        cardDup = 1;
                    }
                }

                // porównanie nowej karty z każdą kolejną nową,
                // w celu uniknięcia duplikatów

                for (j=0; j < i; j++)
                {
                    if ((finalRank[i] == finalRank[j]) &&
                        (finalSuit[i] == finalSuit[j]))
                    {
                        cardDup = 1;
                    }
                }
            } while (cardDup == 1);
            ranksinHand[finalRank[i]]++;
            suitsinHand[finalSuit[i]]++;
        }
    }
}
