#include <iostream>

class Wektor    // wersja 0.1, okrojona
{
public:
    size_t const m_rozmiar;
    int *  const m_ptab;

    Wektor(size_t n)
    : m_rozmiar(n), m_ptab(new int[n])
    { }
    Wektor (Wektor const& w)
    : m_rozmiar(w.m_rozmiar), m_ptab (new int [w.m_rozmiar])
    {
       for (size_t i = 0; i < m_rozmiar; i++)
          m_ptab[i] = w[i];
    }

    ~Wektor() { delete [] m_ptab; }
      
    size_t size() const     { return m_rozmiar; }
      
    int & at(int n)         { return m_ptab[n]; }
    int   at(int n) const   { return m_ptab[n]; }
    int & operator[](int n)         { return m_ptab[n]; }
    int   operator[](int n) const   { return m_ptab[n]; }
};

void f(Wektor w)
{
    w[1] = 100;
}

int main()
{
    Wektor v(10);
    v[1] = 1;
    std::cout << "przed wywolaniem f(v) wartosc v[1] = " << v[1] << "\n";
    f(v);
    std::cout << "teraz wartosc v[1] = " << v[1] << "\n";
}
