#include <QtGui>
#include <ginac/ginac.h>
#include <sstream>
#include "okno.h"


std::string pochodna_po_x (std::string const& s, std::string & komunikat)
{
   try {
      GiNaC::symbol x ("x");                 // zmienna niezalena
      GiNaC::lst lista(x);                   // potrzebne do definicji funkcji
      GiNaC::ex funkcja (s, lista);          // definicja funkcji z napisu
      GiNaC::ex pochodna = funkcja.diff(x);  // obliczenie pochodnej funkcji
      komunikat.erase();          // jest OK: zerujemy kumunikat diagnostyczny
      std::ostringstream S;       // konwersja pochodnej na std::string
      S << pochodna;
      return S.str();             // OK: zwracamy pochodn w formie napisu             
   }
   catch(std::exception const& e)   // tu obsugujemy wyjtki z biblioteki GiNaC
   {
      komunikat = e.what();         // przechwycenie komunikatu diagnostycznego 
   }
   return std::string();            // taka warto sygnalizuje wystpienie bdu
}


Okno::Okno()
{
    QTextCodec::setCodecForTr(QTextCodec::codecForName("Windows-1250"));
    setWindowTitle(tr("Kalkulator pochodnych"));
 
    QGridLayout* layout = new QGridLayout;
    QLabel* echoLabel = new QLabel(tr("Wprowad funkcj f zmiennej x:"));
    layout->addWidget(echoLabel, 0, 0, 1, 0);
    layout->addWidget(new QLabel(tr("<b>f(x) =</b>")),1,0);
    layout->addWidget(new QLabel(tr("<b>f'(x) =</b>")),2,0);
    _f0 = new QLineEdit;
    layout->addWidget(_f0, 1, 1);
    _f1 = new QLabel;
    layout->addWidget(_f1, 2, 1);
    setLayout(layout);

    connect(_f0, SIGNAL(editingFinished()), this, SLOT(slotTextChanged()));
}

void Okno::slotTextChanged()
{
     QString fun = _f0->text();
     std::string komunikat;
     std::string funkcja  = qPrintable(fun);     
     std::string pochodna = pochodna_po_x(funkcja, komunikat);
     
     QString wynik (pochodna.c_str());
     if ( pochodna.empty() )
       wynik = komunikat.c_str();
     _f1->setText(wynik);
}
